/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.infinispan.client.hotrod.transaction.lookup.RemoteTransactionManagerLookup;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.context.AbstractContext;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.server.eviction.EvictionConfiguration;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerParameters;
import org.wildfly.clustering.session.infinispan.remote.SessionManagerNearCacheFactory;

public class HotRodSessionManagerFactoryContext<CC, SC>
extends AbstractContext<SessionManagerFactory<CC, SC>> {
    private static final String SERVER_NAME = "server";
    private final SessionManagerFactory<CC, SC> factory;

    public HotRodSessionManagerFactoryContext(final HotRodSessionManagerParameters parameters, String memberName, final org.wildfly.clustering.function.Supplier<SC> contextFactory) {
        RemoteCacheManager container = new RemoteCacheManager(parameters.getRemoteCacheContainerConfigurator().configure(new ConfigurationBuilder()));
        this.accept(() -> ((RemoteCacheManager)container).close());
        ClassLoader loader = HotRodSessionManagerFactory.class.getClassLoader();
        UserMarshaller marshaller = new UserMarshaller((Supplier)MediaTypes.WILDFLY_PROTOSTREAM, (ByteBufferMarshaller)new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build()));
        Configuration configuration = container.getConfiguration();
        final OptionalInt sizeThreshold = parameters.getNearCacheMode().enabled() ? OptionalInt.of(Short.MAX_VALUE) : OptionalInt.empty();
        Consumer configurator = arg_0 -> this.lambda$new$0((Marshaller)marshaller, parameters, sizeThreshold, arg_0);
        String deploymentName = parameters.getDeploymentName();
        configuration.addRemoteCache(deploymentName, (java.util.function.Consumer)configurator);
        this.accept(() -> configuration.removeRemoteCache(deploymentName));
        final SessionManagerFactoryConfiguration managerFactoryConfiguration = new SessionManagerFactoryConfiguration<SC>(this){
            final /* synthetic */ HotRodSessionManagerFactoryContext this$0;
            {
                this.this$0 = this$0;
            }

            public OptionalInt getSizeThreshold() {
                return sizeThreshold;
            }

            public ByteBufferMarshaller getMarshaller() {
                return parameters.getSessionAttributeMarshaller();
            }

            public org.wildfly.clustering.function.Supplier<SC> getSessionContextFactory() {
                return contextFactory;
            }

            public Immutability getImmutability() {
                return Immutability.getDefault();
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return parameters.getSessionAttributePersistenceStrategy();
            }

            public String getDeploymentName() {
                return parameters.getDeploymentName();
            }

            public String getServerName() {
                return HotRodSessionManagerFactoryContext.SERVER_NAME;
            }

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }
        };
        final DataFormat format = DataFormat.builder().keyMarshaller((Marshaller)marshaller).keyType(MediaType.APPLICATION_OCTET_STREAM).valueMarshaller((Marshaller)marshaller).valueType(MediaType.APPLICATION_OCTET_STREAM).build();
        final RemoteCache cache = container.getCache(parameters.getDeploymentName());
        cache.start();
        this.accept(() -> ((RemoteCache)cache).stop());
        this.factory = new HotRodSessionManagerFactory(new HotRodSessionManagerFactory.Configuration<SC>(){
            final /* synthetic */ HotRodSessionManagerFactoryContext this$0;
            {
                this.this$0 = this$0;
            }

            public SessionManagerFactoryConfiguration<SC> getSessionManagerFactoryConfiguration() {
                return managerFactoryConfiguration;
            }

            public RemoteCacheConfiguration getCacheConfiguration() {
                return RemoteCacheConfiguration.of((RemoteCache)cache.withDataFormat(format));
            }
        });
        this.accept(() -> this.factory.close());
    }

    public SessionManagerFactory<CC, SC> get() {
        return this.factory;
    }

    private /* synthetic */ void lambda$new$0(Marshaller marshaller, HotRodSessionManagerParameters parameters, final OptionalInt sizeThreshold, RemoteCacheConfigurationBuilder builder) {
        builder.configuration("{\n\t\"local-cache\" : {\n\t\t\"encoding\" : {\n\t\t\t\"key\" : {\n\t\t\t\t\"media-type\" : \"application/octet-stream\"\n\t\t\t},\n\t\t\t\"value\" : {\n\t\t\t\t\"media-type\" : \"application/octet-stream\"\n\t\t\t}\n\t\t},\n\t\t\"expiration\" : {\n\t\t\t\"interval\" : 1000\n\t\t},\n\t\t\"transaction\" : {\n\t\t\t\"mode\" : \"NON_XA\",\n\t\t\t\"locking\" : \"PESSIMISTIC\"\n\t\t}\n\t}\n}").forceReturnValues(false).marshaller(marshaller).nearCacheMode(parameters.getNearCacheMode()).nearCacheFactory((NearCacheFactory)(parameters.getNearCacheMode().invalidated() ? new SessionManagerNearCacheFactory(new EvictionConfiguration(){
            final /* synthetic */ HotRodSessionManagerFactoryContext this$0;
            {
                this.this$0 = this$0;
            }

            public OptionalInt getSizeThreshold() {
                return sizeThreshold;
            }
        }) : null)).transactionManagerLookup(RemoteTransactionManagerLookup.getInstance()).transactionMode(parameters.getTransactionMode());
    }
}

