/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerExtension;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheContainerConfigurator;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.cache.SessionManagerITCase;
import org.wildfly.clustering.session.cache.SessionManagerParameters;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactoryContext;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerParameters;

public class HotRodSessionManagerITCase
extends SessionManagerITCase<HotRodSessionManagerParameters> {
    @RegisterExtension
    static final InfinispanServerExtension INFINISPAN = new InfinispanServerExtension();

    HotRodSessionManagerITCase() {
        super(HotRodSessionManagerFactoryContext::new);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HotRodSessionManagerArgumentsProvider.class)
    public void basic(HotRodSessionManagerParameters parameters) {
        super.basic((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ConcurrentHotRodSessionManagerArgumentsProvider.class)
    public void concurrent(HotRodSessionManagerParameters parameters) throws InterruptedException, ExecutionException {
        super.concurrent((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExpirationHotRodSessionManagerArgumentsProvider.class)
    public void expiration(HotRodSessionManagerParameters parameters) throws InterruptedException {
        super.expiration((SessionManagerParameters)parameters);
    }

    static class ExpirationHotRodSessionManagerArgumentsProvider
    extends HotRodSessionManagerArgumentsProvider {
        ExpirationHotRodSessionManagerArgumentsProvider() {
            this.marshallerClass = ProtoStreamTesterFactory.class;
        }
    }

    static class ConcurrentHotRodSessionManagerArgumentsProvider
    extends HotRodSessionManagerArgumentsProvider {
        ConcurrentHotRodSessionManagerArgumentsProvider() {
            this.marshallerClass = ProtoStreamTesterFactory.class;
        }
    }

    static class HotRodSessionManagerArgumentsProvider
    implements ArgumentsProvider {
        Class<? extends MarshallingTesterFactory> marshallerClass = MarshallingTesterFactory.class;
        Set<NearCacheMode> nearCacheModes = EnumSet.of(NearCacheMode.DISABLED);
        Set<TransactionMode> transactionModes = EnumSet.of(TransactionMode.NONE);

        HotRodSessionManagerArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            Stream.Builder<Arguments> builder = Stream.builder();
            for (MarshallingTesterFactory marshallingTesterFactory : ServiceLoader.load(this.marshallerClass, this.marshallerClass.getClassLoader())) {
                final ByteBufferMarshaller marshaller = marshallingTesterFactory.getMarshaller();
                for (final TransactionMode transactionMode : this.transactionModes) {
                    for (final NearCacheMode nearCacheMode : this.nearCacheModes) {
                        for (final SessionAttributePersistenceStrategy strategy : EnumSet.allOf(SessionAttributePersistenceStrategy.class)) {
                            builder.add(Arguments.of((Object[])new Object[]{new HotRodSessionManagerParameters(){
                                final /* synthetic */ HotRodSessionManagerArgumentsProvider this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                public ByteBufferMarshaller getSessionAttributeMarshaller() {
                                    return marshaller;
                                }

                                public SessionAttributePersistenceStrategy getSessionAttributePersistenceStrategy() {
                                    return strategy;
                                }

                                @Override
                                public NearCacheMode getNearCacheMode() {
                                    return nearCacheMode;
                                }

                                @Override
                                public TransactionMode getTransactionMode() {
                                    return transactionMode;
                                }

                                @Override
                                public RemoteCacheContainerConfigurator getRemoteCacheContainerConfigurator() {
                                    return INFINISPAN;
                                }

                                public String toString() {
                                    return Map.of(ByteBufferMarshaller.class.getSimpleName(), marshaller.toString(), SessionAttributePersistenceStrategy.class.getSimpleName(), strategy).toString();
                                }
                            }}));
                        }
                    }
                }
            }
            return builder.build();
        }
    }
}

