/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.server.cache.CacheStrategy;
import org.wildfly.clustering.server.listener.ConsumerRegistry;
import org.wildfly.clustering.server.local.manager.SimpleIdentifierFactoryService;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.CachedSessionManager;
import org.wildfly.clustering.session.cache.DetachedSession;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.attributes.MarshalledValueMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.coarse.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.session.container.ContainerProvider;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManager;
import org.wildfly.clustering.session.infinispan.remote.attributes.CoarseSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.remote.attributes.FineSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.remote.metadata.HotRodSessionMetaDataFactory;

public class HotRodSessionManagerFactory<CC, SC>
implements SessionManagerFactory<CC, SC> {
    private static final System.Logger LOGGER = System.getLogger(HotRodSessionManagerFactory.class.getName());
    private final RemoteCacheConfiguration configuration;
    private final Function<SessionManagerConfiguration<CC>, Registrar<SessionManager<SC>>> managerRegistrarFactory;
    private final SessionFactory<CC, SessionMetaDataEntry<SC>, Object, SC> sessionFactory;
    private final Function<CC, String> contextIdentifier;
    private final Map<String, SessionManager<SC>> managers = new ConcurrentHashMap<String, SessionManager<SC>>();

    public <S, L> HotRodSessionManagerFactory(final Configuration<SC> configuration) {
        final ContainerProvider provider = ServiceLoader.load(ContainerProvider.class, ContainerProvider.class.getClassLoader()).findFirst().orElseThrow();
        LOGGER.log(System.Logger.Level.DEBUG, "{0} configured for {1} container", this.getClass().getSimpleName(), provider);
        this.contextIdentifier = arg_0 -> ((ContainerProvider)provider).getId(arg_0);
        this.configuration = configuration.getCacheConfiguration();
        final HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(this.configuration);
        final SessionAttributesFactory<CC, ?> attributesFactory = this.createSessionAttributesFactory(configuration, provider);
        final ConsumerRegistry expirationListenerRegistry = ConsumerRegistry.newInstance();
        this.sessionFactory = new HotRodSessionFactory(new HotRodSessionFactory.Configuration<CC, Object, SC>(){
            final /* synthetic */ HotRodSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
            }

            public SessionMetaDataFactory<SessionMetaDataEntry<SC>> getSessionMetaDataFactory() {
                return metaDataFactory;
            }

            public SessionAttributesFactory<CC, Object> getSessionAttributesFactory() {
                return attributesFactory;
            }

            public org.wildfly.clustering.function.Supplier<SC> getSessionContextFactory() {
                return configuration.getSessionManagerFactoryConfiguration().getSessionContextFactory();
            }

            @Override
            public RemoteCacheConfiguration getCacheConfiguration() {
                return configuration.getCacheConfiguration();
            }

            @Override
            public java.util.function.Consumer<ImmutableSession> getSessionExpirationListener() {
                return expirationListenerRegistry;
            }
        });
        this.managerRegistrarFactory = new Function<SessionManagerConfiguration<CC>, Registrar<SessionManager<SC>>>(this){
            final /* synthetic */ HotRodSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
            }

            public Registrar<SessionManager<SC>> apply(final SessionManagerConfiguration<CC> managerConfiguration) {
                return new Registrar<SessionManager<SC>>(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Registration register(SessionManager<SC> manager) {
                        Object context = managerConfiguration.getContext();
                        String contextId = provider.getId(context);
                        this.this$1.this$0.managers.put(contextId, manager);
                        Registration managerRegistration = () -> this.this$1.this$0.managers.remove(contextId);
                        Registration expirationRegistration = expirationListenerRegistry.register((Object)managerConfiguration.getExpirationListener());
                        return Registration.composite(List.of(expirationRegistration, managerRegistration));
                    }
                };
            }
        };
    }

    SessionManager<SC> findSessionManager(CC context) {
        return this.managers.get(this.contextIdentifier.apply(context));
    }

    public SessionManager<SC> createSessionManager(SessionManagerConfiguration<CC> configuration) {
        RemoteCacheConfiguration cacheConfiguration = this.configuration;
        SessionFactory<CC, SessionMetaDataEntry<SC>, Object, SC> sessionFactory = this.sessionFactory;
        SimpleIdentifierFactoryService identifierFactory = new SimpleIdentifierFactoryService((Supplier)configuration.getIdentifierFactory());
        BiFunction detachedSessionFactory = (id, context) -> Optional.ofNullable(this.findSessionManager(configuration.getContext())).map(manager -> new DetachedSession(manager, id, context)).orElse(null);
        final Registrar registrar = (Registrar)this.managerRegistrarFactory.apply(configuration);
        CachedSessionManager manager = new CachedSessionManager<SC>(this, (SessionManager)new HotRodSessionManager(new HotRodSessionManager.Configuration<CC, SessionMetaDataEntry<SC>, Object, SC>(){
            final /* synthetic */ IdentifierFactoryService val$identifierFactory;
            final /* synthetic */ SessionFactory val$sessionFactory;
            final /* synthetic */ BiFunction val$detachedSessionFactory;
            final /* synthetic */ SessionManagerConfiguration val$configuration;
            final /* synthetic */ RemoteCacheConfiguration val$cacheConfiguration;
            final /* synthetic */ HotRodSessionManagerFactory this$0;
            {
                this.val$identifierFactory = identifierFactoryService;
                this.val$sessionFactory = sessionFactory;
                this.val$detachedSessionFactory = biFunction;
                this.val$configuration = sessionManagerConfiguration;
                this.val$cacheConfiguration = remoteCacheConfiguration;
                this.this$0 = this$0;
            }

            public IdentifierFactoryService<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionFactory<CC, SessionMetaDataEntry<SC>, Object, SC> getSessionFactory() {
                return this.val$sessionFactory;
            }

            public BiFunction<String, SC, Session<SC>> getDetachedSessionFactory() {
                return this.val$detachedSessionFactory;
            }

            public CC getContext() {
                return this.val$configuration.getContext();
            }

            public Consumer<ImmutableSession> getExpirationListener() {
                return this.val$configuration.getExpirationListener();
            }

            public Optional<Duration> getMaxIdle() {
                return this.val$configuration.getMaxIdle();
            }

            @Override
            public RemoteCacheConfiguration getCacheConfiguration() {
                return this.val$cacheConfiguration;
            }
        }), (CacheFactory)CacheStrategy.CONCURRENT){
            private final AtomicReference<Registration> registration;
            final /* synthetic */ HotRodSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
                super(manager, cacheFactory);
                this.registration = new AtomicReference();
            }

            public void start() {
                this.registration.set(registrar.register((Object)this));
                super.start();
            }

            public void stop() {
                try {
                    super.stop();
                }
                finally {
                    Consumer.close().accept((Object)this.registration.getAndSet(null));
                }
            }
        };
        return manager;
    }

    public void close() {
        this.sessionFactory.close();
    }

    private <S, L> SessionAttributesFactory<CC, ?> createSessionAttributesFactory(Configuration<SC> configuration, ContainerProvider<CC, S, L, SC> provider) {
        switch (configuration.getSessionManagerFactoryConfiguration().getAttributePersistenceStrategy()) {
            case FINE: {
                BiFunction passivationNotifierFactory = (session, context) -> Optional.ofNullable(this.findSessionManager(context)).map(manager -> new ImmutableSessionAttributeActivationNotifier(provider, provider.getDetachableSession(manager, session, context))).orElse(null);
                return new FineSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, configuration.getCacheConfiguration());
            }
            case COARSE: {
                BiFunction passivationNotifierFactory = (session, context) -> Optional.ofNullable(this.findSessionManager(context)).map(manager -> new ImmutableSessionActivationNotifier(provider, provider.getDetachableSession(manager, session, context), session.getAttributes().values())).orElse(null);
                return new CoarseSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, configuration.getCacheConfiguration());
            }
        }
        throw new IllegalStateException();
    }

    public static interface Configuration<SC> {
        public SessionManagerFactoryConfiguration<SC> getSessionManagerFactoryConfiguration();

        public RemoteCacheConfiguration getCacheConfiguration();
    }
}

