/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.spec.container.servlet;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebServlet(value={"/session"})
public class SessionServlet
extends HttpServlet {
    private static final long serialVersionUID = 2878267318695777395L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String query = request.getQueryString();
        this.getServletContext().log(String.format("[%s] %s%s", request.getMethod(), request.getRequestURI(), query != null ? "?" + query : ""));
        super.service(request, response);
        HttpSession session = request.getSession(false);
        if (session != null) {
            response.setHeader("session-id", session.getId());
        }
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) {
        SessionServlet.recordSession(request, response, AtomicInteger::get);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        SessionServlet.recordSession(request, response, AtomicInteger::incrementAndGet);
    }

    private static void recordSession(HttpServletRequest request, HttpServletResponse response, ToIntFunction<AtomicInteger> count) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            UUID value;
            AtomicInteger counter = (AtomicInteger)session.getAttribute("counter");
            if (counter != null) {
                response.setIntHeader("counter", count.applyAsInt(counter));
            }
            if ((value = (UUID)session.getAttribute("immutable")) != null) {
                response.setHeader("immutable", value.toString());
            }
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(true);
        UUID immutableValue = UUID.randomUUID();
        session.setAttribute("immutable", (Object)immutableValue);
        response.addHeader("immutable", immutableValue.toString());
        AtomicInteger counter = new AtomicInteger(0);
        session.setAttribute("counter", (Object)counter);
        response.addIntHeader("counter", counter.get());
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }
}

