/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.spec.servlet;

import java.util.function.Consumer;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;

public enum HttpSessionActivationListenerProvider implements SessionEventListenerSpecificationProvider<HttpSession, HttpSessionActivationListener>
{
    INSTANCE;


    public Class<HttpSessionActivationListener> getEventListenerClass() {
        return HttpSessionActivationListener.class;
    }

    public Consumer<HttpSession> preEvent(HttpSessionActivationListener listener) {
        return session -> listener.sessionWillPassivate(new HttpSessionEvent(session));
    }

    public Consumer<HttpSession> postEvent(HttpSessionActivationListener listener) {
        return session -> listener.sessionDidActivate(new HttpSessionEvent(session));
    }

    public HttpSessionActivationListener asEventListener(final Consumer<HttpSession> preEvent, final Consumer<HttpSession> postEvent) {
        return new HttpSessionActivationListener(){
            final /* synthetic */ HttpSessionActivationListenerProvider this$0;
            {
                this.this$0 = this$0;
            }

            public void sessionWillPassivate(HttpSessionEvent event) {
                preEvent.accept(event.getSession());
            }

            public void sessionDidActivate(HttpSessionEvent event) {
                postEvent.accept(event.getSession());
            }
        };
    }
}

