/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.spec.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.AbstractImmutableHttpSession;

public enum JakartaServletSpecificationProvider implements SessionSpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener>
{
    INSTANCE;


    public HttpSession asSession(final ImmutableSession session, final ServletContext context) {
        return new AbstractImmutableHttpSession(){

            public ServletContext getServletContext() {
                return context;
            }

            public String getId() {
                return session.getId();
            }

            public long getCreationTime() {
                return session.getMetaData().getCreationTime().toEpochMilli();
            }

            public int getMaxInactiveInterval() {
                return (int)session.getMetaData().getTimeout().getSeconds();
            }

            public long getLastAccessedTime() {
                return session.getMetaData().getLastAccessTime().toEpochMilli();
            }

            public boolean isNew() {
                return session.getMetaData().isNew();
            }

            public Enumeration<String> getAttributeNames() {
                return Collections.enumeration(session.getAttributes().getAttributeNames());
            }

            public Object getAttribute(String name) {
                return session.getAttributes().getAttribute(name);
            }
        };
    }

    public Class<HttpSessionActivationListener> getSessionActivationListenerClass() {
        return HttpSessionActivationListener.class;
    }

    public Consumer<HttpSession> prePassivate(HttpSessionActivationListener listener) {
        return session -> listener.sessionWillPassivate(new HttpSessionEvent(session));
    }

    public Consumer<HttpSession> postActivate(HttpSessionActivationListener listener) {
        return session -> listener.sessionDidActivate(new HttpSessionEvent(session));
    }

    public HttpSessionActivationListener asSessionActivationListener(final Consumer<HttpSession> prePassivate, final Consumer<HttpSession> postActivate) {
        return new HttpSessionActivationListener(){

            public void sessionWillPassivate(HttpSessionEvent event) {
                prePassivate.accept(event.getSession());
            }

            public void sessionDidActivate(HttpSessionEvent event) {
                postActivate.accept(event.getSession());
            }
        };
    }
}

