/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.spec.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.time.Duration;
import java.util.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.spec.servlet.AbstractHttpSession;

public class DetachedHttpSession<C>
extends AbstractHttpSession
implements HttpSession.Accessor {
    private final Session<C> session;

    public DetachedHttpSession(SessionManager<C> manager, String id, ServletContext context) {
        this(manager.getDetachedSession(id), context);
    }

    private DetachedHttpSession(Session<C> session, ServletContext context) {
        super((ImmutableSession)session, context);
        this.session = session;
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.getMetaData().setTimeout(Duration.ofSeconds(interval));
    }

    public void setAttribute(String name, Object value) {
        this.session.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.session.getAttributes().remove(name);
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public void access(Consumer<HttpSession> consumer) {
        consumer.accept(this);
    }
}

