/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.spec.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.AbstractHttpSession;
import org.wildfly.clustering.session.spec.servlet.DetachedHttpSession;

public class HttpSessionProvider<C>
implements SessionSpecificationProvider<HttpSession, ServletContext> {
    private final SessionManager<C> manager;

    public HttpSessionProvider(SessionManager<C> manager) {
        this.manager = manager;
    }

    public HttpSession asSession(ImmutableSession session, ServletContext context) {
        final DetachedHttpSession<C> detached = new DetachedHttpSession<C>(this.manager, session.getId(), context);
        final HttpSession.Accessor accessor = new HttpSession.Accessor(){

            public void access(Consumer<HttpSession> consumer) {
                consumer.accept(detached);
            }
        };
        return new AbstractHttpSession(session, context){

            public void setMaxInactiveInterval(int interval) {
            }

            public void setAttribute(String name, Object value) {
            }

            public void removeAttribute(String name) {
            }

            public void invalidate() {
            }

            public HttpSession.Accessor getAccessor() {
                return accessor;
            }
        };
    }
}

