/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.server.manager.Manager;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionStatistics;

public interface SessionManager<C, B extends Batch>
extends Manager<String, B> {
    default public Session<C> createSession(String id) {
        try {
            return this.createSessionAsync(id).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
    }

    public CompletionStage<Session<C>> createSessionAsync(String var1);

    default public Session<C> findSession(String id) {
        try {
            return this.findSessionAsync(id).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
    }

    public CompletionStage<Session<C>> findSessionAsync(String var1);

    default public ImmutableSession findImmutableSession(String id) {
        try {
            return this.findImmutableSessionAsync(id).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
    }

    public CompletionStage<ImmutableSession> findImmutableSessionAsync(String var1);

    public SessionStatistics getStatistics();
}

