/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public interface ImmutableSessionAttributes {
    public Set<String> getAttributeNames();

    public Object getAttribute(String var1);

    default public <T> Map<String, T> getAttributes(Class<T> targetClass) {
        Set<String> names = this.getAttributeNames();
        if (names.isEmpty()) {
            return Map.of();
        }
        TreeMap<String, T> result = new TreeMap<String, T>();
        for (String name : names) {
            Object attribute = this.getAttribute(name);
            if (!targetClass.isInstance(attribute)) continue;
            result.put(name, targetClass.cast(attribute));
        }
        return Collections.unmodifiableMap(result);
    }
}

