/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container;

import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.wildfly.clustering.arquillian.Deployment;
import org.wildfly.clustering.session.container.ClientTester;
import org.wildfly.clustering.session.container.SessionManagementEndpointConfiguration;
import org.wildfly.clustering.session.container.SessionManagementTesterConfiguration;

public class SessionManagementTester
implements ClientTester,
SessionManagementEndpointConfiguration {
    private static final int ITERATIONS = 4;
    private static final int CONCURRENCY = 40;
    private static final Duration FAILOVER_DURATION = Duration.ofSeconds(2L);
    private final ExecutorService executor = Executors.newFixedThreadPool(40);
    private final SessionManagementTesterConfiguration configuration;

    public SessionManagementTester(SessionManagementTesterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @Override
    public void test(List<Deployment> deployments) {
        HttpClient client = ((HttpClient.Builder)this.configuration.getHttpClientConfigurator().apply(HttpClient.newBuilder())).cookieHandler(new CookieManager()).executor(this.executor).build();
        List endpoints = deployments.stream().map(this.configuration::locateEndpoint).collect(Collectors.toList());
        for (URI uri : endpoints) {
            ((CompletableFuture)SessionManagementTester.request(client, uri, HttpMethod.HEAD).thenAccept(response -> {
                Assertions.assertEquals((int)200, (int)response.statusCode());
                Assertions.assertFalse((boolean)response.headers().firstValue("session-id").isPresent());
                Assertions.assertFalse((boolean)response.headers().firstValueAsLong("immutable").isPresent());
                Assertions.assertFalse((boolean)response.headers().firstValueAsLong("counter").isPresent());
            })).join();
        }
        Map.Entry entry = (Map.Entry)((CompletableFuture)SessionManagementTester.request(client, (URI)endpoints.get(0), HttpMethod.PUT).thenApply(response -> {
            Assertions.assertEquals((int)200, (int)response.statusCode());
            String sessionId = response.headers().firstValue("session-id").orElse(null);
            String immutableValue = response.headers().firstValue("immutable").orElse(null);
            return new AbstractMap.SimpleImmutableEntry<String, String>(sessionId, immutableValue);
        })).join();
        String sessionId = (String)entry.getKey();
        String immutableValue = (String)entry.getValue();
        Assertions.assertNotNull((Object)sessionId);
        Assertions.assertNotNull((Object)immutableValue);
        AtomicLong expected = new AtomicLong(0L);
        for (int i = 0; i < 4; ++i) {
            for (URI uri : endpoints) {
                String message = String.format("%s[%d]", uri, i);
                long value = (Long)((CompletableFuture)SessionManagementTester.request(client, uri, HttpMethod.GET).thenApply(response -> {
                    Assertions.assertEquals((int)200, (int)response.statusCode(), (String)message);
                    Assertions.assertEquals((Object)sessionId, response.headers().firstValue("session-id").orElse(null), (String)message);
                    Assertions.assertEquals((Object)immutableValue, response.headers().firstValue("immutable").orElse(null), (String)message);
                    return response.headers().firstValueAsLong("counter").orElse(0L);
                })).join();
                Assertions.assertEquals((long)expected.incrementAndGet(), (long)value, (String)message);
                ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(40);
                for (int j = 0; j < 40; ++j) {
                    CompletionStage future = SessionManagementTester.request(client, uri, HttpMethod.GET).thenApply(response -> {
                        Assertions.assertEquals((int)200, (int)response.statusCode(), (String)message);
                        Assertions.assertEquals((Object)sessionId, response.headers().firstValue("session-id").orElse(null), (String)message);
                        Assertions.assertEquals((Object)immutableValue, response.headers().firstValue("immutable").orElse(null), (String)message);
                        return response.headers().firstValueAsLong("counter").orElse(0L);
                    });
                    futures.add(future);
                }
                expected.addAndGet(40L);
                Assertions.assertEquals((long)40L, (long)futures.stream().map(CompletableFuture::join).distinct().count(), (String)message);
                try {
                    Thread.sleep(FAILOVER_DURATION.getSeconds(), FAILOVER_DURATION.getNano());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                value = (Long)((CompletableFuture)SessionManagementTester.request(client, uri, HttpMethod.GET).thenApply(response -> {
                    Assertions.assertEquals((int)200, (int)response.statusCode(), (String)message);
                    Assertions.assertEquals((Object)sessionId, response.headers().firstValue("session-id").orElse(null), (String)message);
                    Assertions.assertEquals((Object)immutableValue, response.headers().firstValue("immutable").orElse(null), (String)message);
                    return response.headers().firstValueAsLong("counter").orElse(0L);
                })).join();
                Assertions.assertEquals((long)expected.incrementAndGet(), (long)value, (String)message);
                if (this.configuration.isTransactional()) continue;
                try {
                    Thread.sleep(FAILOVER_DURATION.getSeconds(), FAILOVER_DURATION.getNano());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        ((CompletableFuture)SessionManagementTester.request(client, (URI)endpoints.get(0), HttpMethod.DELETE).thenAccept(response -> {
            Assertions.assertEquals((int)200, (int)response.statusCode());
            Assertions.assertNull(response.headers().firstValue("session-id").orElse(null));
        })).join();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(2);
        for (URI uri : endpoints) {
            futures.add(SessionManagementTester.request(client, uri, HttpMethod.HEAD).thenAccept(response -> {
                Assertions.assertEquals((int)200, (int)response.statusCode());
                Assertions.assertFalse((boolean)response.headers().firstValue("session-id").isPresent());
                Assertions.assertFalse((boolean)response.headers().firstValueAsLong("counter").isPresent());
            }));
        }
        futures.forEach(CompletableFuture::join);
    }

    private static CompletableFuture<HttpResponse<Void>> request(HttpClient client, URI uri, HttpMethod method) {
        return client.sendAsync(HttpRequest.newBuilder(uri).method(method.name(), HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.discarding());
    }

    static enum HttpMethod {
        HEAD,
        GET,
        PUT,
        DELETE;

    }
}

