/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.wildfly.clustering.arquillian.Deployment;
import org.wildfly.clustering.arquillian.DeploymentContainer;
import org.wildfly.clustering.arquillian.DeploymentContainerRegistry;
import org.wildfly.clustering.session.container.SessionManagementEndpointConfiguration;
import org.wildfly.clustering.session.container.SessionManagementTester;
import org.wildfly.clustering.session.container.SessionManagementTesterConfiguration;

public abstract class AbstractSessionManagerITCase
implements Consumer<Archive<?>>,
SessionManagementTesterConfiguration,
Supplier<WebArchive> {
    @RegisterExtension
    static final ArquillianExtension ARQUILLIAN = new ArquillianExtension();
    @ArquillianResource
    private DeploymentContainerRegistry registry;
    private final Set<String> containerNames;

    protected AbstractSessionManagerITCase() {
        this.containerNames = Set.of();
    }

    protected AbstractSessionManagerITCase(Set<String> containerNames) {
        this.containerNames = containerNames;
    }

    @Override
    public WebArchive get() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(this.getClass().getSimpleName() + ".war"))).addClass(SessionManagementEndpointConfiguration.class)).addPackage(this.getEndpointClass().getPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Archive<?> archive) {
        Collection<DeploymentContainer> containers = this.getContainers();
        ArrayList<Deployment> deployments = new ArrayList<Deployment>(containers.size());
        try (SessionManagementTester tester = new SessionManagementTester(this);){
            for (DeploymentContainer container : containers) {
                deployments.add(container.deploy(archive));
            }
            tester.test(deployments);
        }
        finally {
            for (Deployment deployment : deployments) {
                deployment.close();
            }
        }
    }

    private Collection<DeploymentContainer> getContainers() {
        if (this.containerNames.isEmpty()) {
            return this.registry.getContainers();
        }
        ArrayList<DeploymentContainer> containers = new ArrayList<DeploymentContainer>(this.registry.getContainers().size());
        for (String containerName : this.containerNames) {
            DeploymentContainer container = this.registry.getContainer(containerName);
            if (container == null) {
                throw new IllegalArgumentException(containerName);
            }
            containers.add(container);
        }
        return containers;
    }
}

