/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.session.IdentifierMarshaller;

public class StringIdentifierSerializerTestCase {
    @Test
    public void testString() throws IOException {
        StringIdentifierSerializerTestCase.test((Marshaller<String, ByteBuffer>)IdentifierMarshaller.ISO_LATIN_1, () -> UUID.randomUUID().toString());
    }

    @Test
    public void testBase64() throws IOException {
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        StringIdentifierSerializerTestCase.test((Marshaller<String, ByteBuffer>)IdentifierMarshaller.BASE64, () -> ((SessionIdGenerator)generator).createSessionId());
    }

    @Test
    public void testHex() throws IOException {
        StandardSessionIdGenerator generator = new StandardSessionIdGenerator();
        StringIdentifierSerializerTestCase.test((Marshaller<String, ByteBuffer>)IdentifierMarshaller.HEX, () -> ((org.apache.catalina.SessionIdGenerator)generator).generateSessionId());
    }

    private static void test(Marshaller<String, ByteBuffer> marshaller, Supplier<String> generator) throws IOException {
        for (int i = 0; i < 100; ++i) {
            String id = generator.get();
            ByteBuffer buffer = (ByteBuffer)marshaller.write((Object)id);
            Assertions.assertEquals((Object)id, (Object)marshaller.read((Object)buffer));
        }
    }
}

