/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container;

import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.wildfly.clustering.arquillian.Deployment;
import org.wildfly.clustering.session.container.ClientTester;
import org.wildfly.clustering.session.container.SessionManagementEndpointConfiguration;
import org.wildfly.clustering.session.container.SessionManagementTesterConfiguration;

public class SessionManagementTester
implements ClientTester,
SessionManagementEndpointConfiguration {
    private final ExecutorService executor;
    private final SessionManagementTesterConfiguration configuration;

    public SessionManagementTester(SessionManagementTesterConfiguration configuration) {
        this.executor = Executors.newFixedThreadPool(configuration.getConcurrency());
        this.configuration = configuration;
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @Override
    public void test(List<Deployment> deployments) {
        HttpClient client = ((HttpClient.Builder)this.configuration.getHttpClientConfigurator().apply(HttpClient.newBuilder())).cookieHandler(new CookieManager()).executor(this.executor).build();
        List<URI> endpoints = deployments.stream().map(this.configuration::locateEndpoint).toList();
        for (URI uri : endpoints) {
            ((CompletableFuture)SessionManagementTester.request(client, uri, HttpMethod.HEAD).thenAccept(response -> {
                Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
                Assertions.assertThat(response.headers().firstValue("session-id")).isEmpty();
                Assertions.assertThat((OptionalLong)response.headers().firstValueAsLong("immutable")).isEmpty();
                Assertions.assertThat((OptionalLong)response.headers().firstValueAsLong("counter")).isEmpty();
            })).join();
        }
        Map.Entry entry = (Map.Entry)((CompletableFuture)SessionManagementTester.request(client, endpoints.get(0), HttpMethod.PUT).thenApply(response -> {
            Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
            String sessionId = response.headers().firstValue("session-id").orElse(null);
            String immutableValue = response.headers().firstValue("immutable").orElse(null);
            return new AbstractMap.SimpleImmutableEntry<String, String>(sessionId, immutableValue);
        })).join();
        String sessionId = (String)entry.getKey();
        String immutableValue = (String)entry.getValue();
        Assertions.assertThat((String)sessionId).isNotNull();
        Assertions.assertThat((String)immutableValue).isNotNull();
        AtomicLong expected = new AtomicLong(0L);
        int concurrency = this.configuration.getConcurrency();
        for (int i = 0; i < this.configuration.getIterations(); ++i) {
            for (URI uri : endpoints) {
                String message = String.format("%s[%d]", uri, i);
                long value = (Long)((CompletableFuture)SessionManagementTester.request(client, uri, HttpMethod.GET).thenApply(response -> {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)response.statusCode()).as(message, new Object[0])).isEqualTo(200);
                    ((OptionalAssert)Assertions.assertThat(response.headers().firstValue("session-id")).as(message, new Object[0])).hasValue((Object)sessionId);
                    ((OptionalAssert)Assertions.assertThat(response.headers().firstValue("immutable")).as(message, new Object[0])).hasValue((Object)immutableValue);
                    return response.headers().firstValueAsLong("counter").orElse(0L);
                })).join();
                ((AbstractLongAssert)Assertions.assertThat((long)value).as(message, new Object[0])).isEqualTo(expected.incrementAndGet());
                ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(concurrency);
                for (int j = 0; j < concurrency; ++j) {
                    CompletionStage future = SessionManagementTester.request(client, uri, HttpMethod.GET).thenApply(response -> {
                        ((AbstractIntegerAssert)Assertions.assertThat((int)response.statusCode()).as(message, new Object[0])).isEqualTo(200);
                        ((OptionalAssert)Assertions.assertThat(response.headers().firstValue("session-id")).as(message, new Object[0])).hasValue((Object)sessionId);
                        ((OptionalAssert)Assertions.assertThat(response.headers().firstValue("immutable")).as(message, new Object[0])).hasValue((Object)immutableValue);
                        return response.headers().firstValueAsLong("counter").orElse(0L);
                    });
                    futures.add(future);
                }
                expected.addAndGet(concurrency);
                ((AbstractLongAssert)Assertions.assertThat((long)futures.stream().map(CompletableFuture::join).distinct().count()).as(message, new Object[0])).isEqualTo((long)concurrency);
                try {
                    Thread.sleep(this.configuration.getFailoverGracePeriod().toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                value = (Long)((CompletableFuture)SessionManagementTester.request(client, uri, HttpMethod.GET).thenApply(response -> {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)response.statusCode()).as(message, new Object[0])).isEqualTo(200);
                    ((OptionalAssert)Assertions.assertThat(response.headers().firstValue("session-id")).as(message, new Object[0])).hasValue((Object)sessionId);
                    ((OptionalAssert)Assertions.assertThat(response.headers().firstValue("immutable")).as(message, new Object[0])).hasValue((Object)immutableValue);
                    return response.headers().firstValueAsLong("counter").orElse(0L);
                })).join();
                ((AbstractLongAssert)Assertions.assertThat((long)value).as(message, new Object[0])).isEqualTo(expected.incrementAndGet());
                try {
                    Thread.sleep(this.configuration.getFailoverGracePeriod().toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        ((CompletableFuture)SessionManagementTester.request(client, endpoints.get(0), HttpMethod.DELETE).thenAccept(response -> {
            Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
            Assertions.assertThat(response.headers().firstValue("session-id")).isEmpty();
        })).join();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(2);
        for (URI uri : endpoints) {
            futures.add(SessionManagementTester.request(client, uri, HttpMethod.HEAD).thenAccept(response -> {
                Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
                Assertions.assertThat(response.headers().firstValue("session-id")).isEmpty();
                Assertions.assertThat((OptionalLong)response.headers().firstValueAsLong("counter")).isEmpty();
            }));
        }
        futures.forEach(CompletableFuture::join);
    }

    private static CompletableFuture<HttpResponse<Void>> request(HttpClient client, URI uri, HttpMethod method) {
        return client.sendAsync(HttpRequest.newBuilder(uri).method(method.name(), HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.discarding());
    }

    static enum HttpMethod {
        HEAD,
        GET,
        PUT,
        DELETE;

    }
}

