/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container;

import java.util.function.Function;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.wildfly.clustering.arquillian.AbstractITCase;
import org.wildfly.clustering.arquillian.Tester;
import org.wildfly.clustering.session.container.SessionManagementEndpointConfiguration;
import org.wildfly.clustering.session.container.SessionManagementTester;
import org.wildfly.clustering.session.container.SessionManagementTesterConfiguration;

public abstract class AbstractSessionManagerITCase<A extends Archive<A> & ClassContainer<A>>
extends AbstractITCase<SessionManagementTesterConfiguration, A> {
    @RegisterExtension
    static final ArquillianExtension ARQUILLIAN = new ArquillianExtension();
    private final Class<A> archiveClass;

    protected AbstractSessionManagerITCase(SessionManagementTesterConfiguration configuration, Class<A> archiveClass) {
        this(SessionManagementTester::new, configuration, archiveClass);
    }

    protected AbstractSessionManagerITCase(Function<SessionManagementTesterConfiguration, Tester> testerFactory, SessionManagementTesterConfiguration configuration, Class<A> archiveClass) {
        super(testerFactory, (Object)configuration);
        this.archiveClass = archiveClass;
    }

    public A createArchive(SessionManagementTesterConfiguration configuration) {
        String extension = ShrinkWrap.getDefaultDomain().getConfiguration().getExtensionLoader().getExtensionFromExtensionMapping(this.archiveClass);
        return (A)((ClassContainer)((ClassContainer)((Archive)ShrinkWrap.create(this.archiveClass, (String)(((Object)((Object)this)).getClass().getSimpleName() + extension)))).addClass(SessionManagementEndpointConfiguration.class)).addPackage(configuration.getEndpointClass().getPackage());
    }
}

