/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import java.time.Instant;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.server.manager.Manager;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionStatistics;

public interface SessionManager<C>
extends Manager<String> {
    default public Session<C> createSession(String id) {
        return this.createSession(id, Instant.now());
    }

    default public Session<C> createSession(String id, Instant creationTime) {
        return this.createSessionAsync(id, creationTime).toCompletableFuture().join();
    }

    default public CompletionStage<Session<C>> createSessionAsync(String id) {
        return this.createSessionAsync(id, Instant.now());
    }

    public CompletionStage<Session<C>> createSessionAsync(String var1, Instant var2);

    default public Session<C> findSession(String id) {
        return this.findSessionAsync(id).toCompletableFuture().join();
    }

    public CompletionStage<Session<C>> findSessionAsync(String var1);

    default public ImmutableSession findImmutableSession(String id) {
        return this.findImmutableSessionAsync(id).toCompletableFuture().join();
    }

    public CompletionStage<ImmutableSession> findImmutableSessionAsync(String var1);

    public Session<C> getDetachedSession(String var1);

    public SessionStatistics getStatistics();
}

