/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HexFormat;
import org.wildfly.clustering.marshalling.Marshaller;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IdentifierMarshaller implements Marshaller<String, ByteBuffer>
{
    ISO_LATIN_1{

        public String read(ByteBuffer buffer) {
            if (!buffer.hasArray()) {
                throw new IllegalArgumentException(buffer.toString());
            }
            int offset = buffer.arrayOffset() + buffer.position();
            int length = buffer.remaining();
            return new String(buffer.array(), offset, length, StandardCharsets.ISO_8859_1);
        }

        public ByteBuffer write(String value) {
            return ByteBuffer.wrap(value.getBytes(StandardCharsets.ISO_8859_1));
        }

        @Override
        public boolean validate(String id) {
            return true;
        }
    }
    ,
    BASE64{

        public String read(ByteBuffer buffer) throws IOException {
            return (String)ISO_LATIN_1.read(Base64.getUrlEncoder().encode(buffer));
        }

        public ByteBuffer write(String value) throws IOException {
            return Base64.getUrlDecoder().decode((ByteBuffer)ISO_LATIN_1.write(value));
        }
    }
    ,
    HEX_UPPER{
        private final Marshaller<String, ByteBuffer> marshaller = new HexMarshaller(HexFormat.of().withUpperCase());

        public String read(ByteBuffer buffer) throws IOException {
            return (String)this.marshaller.read((Object)buffer);
        }

        public ByteBuffer write(String value) throws IOException {
            return (ByteBuffer)this.marshaller.write((Object)value);
        }
    }
    ,
    HEX_LOWER{
        private final Marshaller<String, ByteBuffer> marshaller = new HexMarshaller(HexFormat.of().withLowerCase());

        public String read(ByteBuffer buffer) throws IOException {
            return (String)this.marshaller.read((Object)buffer);
        }

        public ByteBuffer write(String value) throws IOException {
            return (ByteBuffer)this.marshaller.write((Object)value);
        }
    };


    public boolean test(Object object) {
        return object instanceof String;
    }

    public boolean validate(String id) {
        try {
            this.write(id);
            return true;
        }
        catch (IOException | IllegalArgumentException e) {
            return false;
        }
    }

    static class HexMarshaller
    implements Marshaller<String, ByteBuffer> {
        private final HexFormat format;

        HexMarshaller(HexFormat format) {
            this.format = format;
        }

        public String read(ByteBuffer buffer) {
            if (!buffer.hasArray()) {
                throw new IllegalArgumentException(buffer.toString());
            }
            return this.format.formatHex(buffer.array(), buffer.arrayOffset(), buffer.limit());
        }

        public ByteBuffer write(String value) {
            return ByteBuffer.wrap(this.format.parseHex(value));
        }

        public boolean test(Object object) {
            return object instanceof String;
        }
    }
}

