/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.context.infinispan.embedded;

import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.jmx.JmxConfigurator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.wildfly.clustering.cache.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.spring.context.AutoDestroyBean;
import org.wildfly.clustering.spring.context.infinispan.embedded.DefaultNonBlockingThreadFactory;
import org.wildfly.clustering.spring.context.infinispan.embedded.ForkChannelConfigurator;
import org.wildfly.clustering.spring.context.infinispan.embedded.InfinispanConfiguration;
import org.wildfly.clustering.spring.context.infinispan.embedded.JChannelConfigurator;

public class EmbeddedCacheManagerBean
extends AutoDestroyBean
implements ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration,
InitializingBean,
ResourceLoaderAware {
    private static final Logger LOGGER = Logger.getLogger(EmbeddedCacheManagerBean.class);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final InfinispanConfiguration configuration;
    private ResourceLoader loader;
    private EmbeddedCacheManager container;
    private JChannelCommandDispatcherFactory commandDispatcherFactory;

    public EmbeddedCacheManagerBean(InfinispanConfiguration configuration) {
        this.configuration = configuration;
    }

    public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
        return this.commandDispatcherFactory;
    }

    public EmbeddedCacheManager getCacheContainer() {
        return this.container;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    public void afterPropertiesSet() throws Exception {
        JChannel channel;
        String resourceName = this.configuration.getConfigurationResource();
        COUNTER.incrementAndGet();
        this.accept(() -> {
            if (COUNTER.decrementAndGet() == 0) {
                Schedulers.shutdown();
            }
        });
        Resource resource = this.loader.getResource(resourceName);
        if (resource == null) {
            throw new FileNotFoundException(resourceName);
        }
        ConfigurationBuilderHolder holder = new ParserRegistry().parse(resource.getInputStream(), MediaType.APPLICATION_XML);
        GlobalConfigurationBuilder global = holder.getGlobalConfigurationBuilder();
        String containerName = global.cacheContainer().name();
        TransportConfiguration transport = global.transport().create();
        JChannelConfigurator configurator = transport.transport() != null ? new JChannelConfigurator(transport, this.loader) : null;
        JChannel jChannel = channel = configurator != null ? configurator.createChannel(null) : null;
        if (channel != null) {
            channel.setName(transport.nodeName());
            channel.setDiscardOwnMessages(true);
            channel.connect(transport.clusterName());
            this.accept(() -> ((JChannel)channel).close());
            GlobalJmxConfiguration jmx = global.jmx().create();
            if (jmx.enabled()) {
                ObjectName prefix = new ObjectName(jmx.domain(), "manager", ObjectName.quote(containerName));
                JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ObjectName)prefix, (String)transport.clusterName(), (boolean)true);
                this.accept(() -> {
                    try {
                        JmxConfigurator.unregisterChannel((JChannel)channel, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ObjectName)prefix, (String)transport.clusterName());
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                });
            }
            Properties properties = new Properties();
            properties.put("channelConfigurator", new ForkChannelConfigurator(channel, containerName));
            global.transport().withProperties(properties);
        }
        JChannelCommandDispatcherFactory jChannelCommandDispatcherFactory = this.commandDispatcherFactory = channel != null ? new JChannelCommandDispatcherFactory(new JChannelCommandDispatcherFactoryConfiguration(){

            public JChannel getChannel() {
                return channel;
            }

            public ByteBufferMarshaller getMarshaller() {
                return this.getMarshallerFactory().apply(JChannelCommandDispatcherFactory.class.getClassLoader());
            }

            public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
                return loader -> new ProtoStreamByteBufferMarshaller(SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader).build());
            }

            public Predicate<Message> getUnknownForkPredicate() {
                return Predicate.not(Message::hasPayload);
            }
        }) : null;
        if (this.commandDispatcherFactory != null) {
            this.accept(() -> ((JChannelCommandDispatcherFactory)this.commandDispatcherFactory).close());
        }
        global.classLoader(this.loader.getClassLoader()).shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER).blockingThreadPool().threadFactory((ThreadFactory)new DefaultThreadFactory(BlockingManager.class)).expirationThreadPool().threadFactory((ThreadFactory)new DefaultThreadFactory(ExpirationManager.class)).listenerThreadPool().threadFactory((ThreadFactory)new DefaultThreadFactory(ListenerInvocation.class)).nonBlockingThreadPool().threadFactory((ThreadFactory)((Object)new DefaultNonBlockingThreadFactory(NonBlockingManager.class))).serialization().marshaller((Marshaller)new ProtoStreamMarshaller(ClassLoaderMarshaller.of((ClassLoader)this.loader.getClassLoader()), builder -> builder.load(this.loader.getClassLoader()))).addContextInitializer(new SerializationContextInitializer(){

            @Deprecated
            public String getProtoFile() {
                return null;
            }

            @Deprecated
            public String getProtoFileName() {
                return null;
            }

            public void registerMarshallers(SerializationContext context) {
            }

            public void registerSchema(SerializationContext context) {
            }
        }).globalState().configurationStorage(ConfigurationStorage.IMMUTABLE).disable();
        this.container = new DefaultCacheManager(holder, false);
        this.container.start();
        this.accept(() -> ((EmbeddedCacheManager)this.container).stop());
    }
}

