/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.context.infinispan.embedded.config;

import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.StringValueResolver;
import org.wildfly.clustering.spring.context.infinispan.embedded.MutableInfinispanConfiguration;

public class InfinispanConfigurationBean
implements MutableInfinispanConfiguration {
    private String resource = "/WEB-INF/infinispan.xml";
    private String templateName = null;
    private StringValueResolver resolver = value -> value;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public String getConfigurationResource() {
        return this.resource;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setResource(String resource) {
        this.resource = this.resolver.resolveStringValue(resource);
    }

    @Override
    public void setTemplate(String templateName) {
        this.templateName = Optional.ofNullable(templateName).map(arg_0 -> ((StringValueResolver)this.resolver).resolveStringValue(arg_0)).orElse(null);
    }

    @Override
    public void accept(AnnotationAttributes attributes) {
        AnnotationAttributes config = attributes.getAnnotation("config");
        this.setResource(config.getString("resource"));
        this.setTemplate(Optional.of(config.getString("template")).filter(Predicate.not(String::isEmpty)).orElse(null));
    }
}

