/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.context.infinispan.embedded;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.wildfly.clustering.spring.context.SessionAttributeMarshaller;
import org.wildfly.clustering.spring.context.SessionPersistenceGranularity;
import org.wildfly.clustering.spring.context.infinispan.embedded.InfinispanSessionManagementParameters;

public class InfinispanSessionManagementArgumentsProvider
implements ArgumentsProvider {
    private final Set<String> templates = Set.of("dist-tx", "repl-tx");

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        Stream.Builder<Arguments> builder = Stream.builder();
        for (final String template : this.templates) {
            for (final SessionPersistenceGranularity strategy : EnumSet.allOf(SessionPersistenceGranularity.class)) {
                for (final SessionAttributeMarshaller marshaller : EnumSet.allOf(SessionAttributeMarshaller.class)) {
                    builder.add(Arguments.of((Object[])new Object[]{new InfinispanSessionManagementParameters(){

                        public SessionPersistenceGranularity getSessionPersistenceGranularity() {
                            return strategy;
                        }

                        public SessionAttributeMarshaller getSessionMarshallerFactory() {
                            return marshaller;
                        }

                        @Override
                        public String getTemplate() {
                            return template;
                        }

                        public String toString() {
                            return Map.of("template", template, "granularity", strategy, "marshaller", marshaller).toString();
                        }
                    }}));
                }
            }
        }
        return builder.build();
    }
}

