/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.context.infinispan.remote;

import java.util.Properties;
import java.util.function.UnaryOperator;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.wildfly.clustering.cache.ContainerProvider;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerContainer;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerExtension;
import org.wildfly.clustering.session.container.AbstractSessionManagerITCase;

public abstract class AbstractHotRodSessionManagerITCase
extends AbstractSessionManagerITCase
implements UnaryOperator<Properties> {
    @RegisterExtension
    static final ContainerProvider<InfinispanServerContainer> INFINISPAN = new InfinispanServerExtension();

    @Override
    public Properties apply(Properties properties) {
        InfinispanServerContainer container = (InfinispanServerContainer)INFINISPAN.getContainer();
        properties.setProperty("infinispan.server.host", container.getHost());
        properties.setProperty("infinispan.server.port", Integer.toString(container.getPort()));
        properties.setProperty("infinispan.server.username", container.getUsername());
        properties.setProperty("infinispan.server.password", String.valueOf(container.getPassword()));
        properties.setProperty("infinispan.server.intelligence", (container.isPortMapping() ? ClientIntelligence.BASIC : ClientIntelligence.HASH_DISTRIBUTION_AWARE).name());
        properties.setProperty("infinispan.server.template", DefaultTemplate.LOCAL.getTemplateName());
        return properties;
    }
}

