/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.hotrod.annotation;

import java.net.URI;
import java.util.Properties;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.wildfly.clustering.web.spring.annotation.IndexedHttpSessionConfiguration;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepository;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.hotrod.annotation.EnableIndexedHotRodHttpSession;

@Configuration(proxyBeanMethods=false)
public class IndexedHotRodHttpSessionConfiguration
extends IndexedHttpSessionConfiguration
implements HotRodSessionRepositoryConfiguration {
    private URI uri;
    private Properties properties = new Properties();
    private String templateName = DefaultTemplate.DIST_SYNC.getTemplateName();

    public IndexedHotRodHttpSessionConfiguration() {
        super(EnableIndexedHotRodHttpSession.class);
    }

    @Bean
    public HotRodSessionRepository sessionRepository() {
        return new HotRodSessionRepository(this);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Autowired(required=false)
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Autowired(required=false)
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Autowired(required=false)
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void accept(AnnotationAttributes attributes) {
        super.accept(attributes);
        AnnotationAttributes config = attributes.getAnnotation("config");
        this.uri = URI.create(config.getString("uri"));
        this.templateName = config.getString("template");
        for (AnnotationAttributes property : config.getAnnotationArray("properties")) {
            this.properties.setProperty(property.getString("name"), property.getString("value"));
        }
    }
}

