/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.hotrod;

import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.commons.marshall.Marshaller;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.IndexResolver;
import org.springframework.session.Session;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.infinispan.client.NearCacheFactory;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.manager.RemoteCacheManager;
import org.wildfly.clustering.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.SimpleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionManagerNearCacheFactory;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactory;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.clustering.web.spring.DistributableSessionRepository;
import org.wildfly.clustering.web.spring.DistributableSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.ImmutableSessionDestroyAction;
import org.wildfly.clustering.web.spring.ImmutableSessionExpirationListener;
import org.wildfly.clustering.web.spring.IndexingConfiguration;
import org.wildfly.clustering.web.spring.SpringSession;
import org.wildfly.clustering.web.spring.SpringSpecificationProvider;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.security.SpringSecurityImmutability;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

public class HotRodSessionRepository
implements FindByIndexNameSessionRepository<SpringSession>,
InitializingBean,
DisposableBean,
LocalContextFactory<Void>,
Registrar<String>,
Registration {
    private final HotRodSessionRepositoryConfiguration configuration;
    private final List<Runnable> stopTasks = new LinkedList<Runnable>();
    private volatile FindByIndexNameSessionRepository<SpringSession> repository;

    public HotRodSessionRepository(HotRodSessionRepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        final ServletContext context = this.configuration.getServletContext();
        final String deploymentName = context.getVirtualServerName() + context.getContextPath();
        String templateName = this.configuration.getTemplateName();
        final Integer maxActiveSessions = this.configuration.getMaxActiveSessions();
        final SessionAttributePersistenceStrategy strategy = this.configuration.getPersistenceStrategy();
        ClassLoader containerLoader = WildFlySecurityManager.getClassLoaderPrivileged(HotRodSessionManagerFactory.class);
        URI uri = this.configuration.getUri();
        Configuration configuration = (uri != null ? HotRodURI.create((URI)uri).toConfigurationBuilder() : new ConfigurationBuilder()).withProperties(this.configuration.getProperties()).marshaller((Marshaller)new ProtoStreamMarshaller((ClassLoaderMarshaller)new SimpleClassLoaderMarshaller(containerLoader), containerLoader)).classLoader(containerLoader).build();
        configuration.addRemoteCache(deploymentName, builder -> builder.forceReturnValues(false).nearCacheMode(maxActiveSessions == null || maxActiveSessions <= 0 ? NearCacheMode.DISABLED : NearCacheMode.INVALIDATED).transactionMode(TransactionMode.NONE).templateName(templateName));
        RemoteCacheManager container = new RemoteCacheManager(this.getClass().getName(), configuration, (Registrar)this);
        container.start();
        this.stopTasks.add(() -> ((RemoteCacheContainer)container).stop());
        ByteBufferMarshaller marshaller = (ByteBufferMarshaller)this.configuration.getMarshallerFactory().apply(context.getClassLoader());
        ByteBufferMarshalledValueFactory marshalledValueFactory = new ByteBufferMarshalledValueFactory(marshaller);
        ServiceLoader<Immutability> loadedImmutability = ServiceLoader.load(Immutability.class, Immutability.class.getClassLoader());
        CompositeImmutability immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), EnumSet.allOf(SpringSecurityImmutability.class), loadedImmutability}));
        HotRodSessionManagerFactory managerFactory = new HotRodSessionManagerFactory((HotRodSessionManagerFactoryConfiguration)new HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, ByteBufferMarshaller, Void>((MarshalledValueFactory)marshalledValueFactory, context, (RemoteCacheContainer)container, (Immutability)immutability){
            final /* synthetic */ MarshalledValueFactory val$marshalledValueFactory;
            final /* synthetic */ ServletContext val$context;
            final /* synthetic */ RemoteCacheContainer val$container;
            final /* synthetic */ Immutability val$immutability;
            {
                this.val$marshalledValueFactory = marshalledValueFactory;
                this.val$context = servletContext;
                this.val$container = remoteCacheContainer;
                this.val$immutability = immutability;
            }

            public Integer getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                return this.val$marshalledValueFactory;
            }

            public String getServerName() {
                return this.val$context.getVirtualServerName();
            }

            public LocalContextFactory<Void> getLocalContextFactory() {
                return HotRodSessionRepository.this;
            }

            public <K, V> RemoteCache<K, V> getCache() {
                String cacheName = this.getDeploymentName();
                try (RemoteCacheContainer.NearCacheRegistration registration = this.val$container.registerNearCacheFactory(cacheName, (NearCacheFactory)new SessionManagerNearCacheFactory(this.getMaxActiveSessions(), this.getAttributePersistenceStrategy()));){
                    RemoteCache remoteCache = this.val$container.getCache(cacheName);
                    return remoteCache;
                }
            }

            public Immutability getImmutability() {
                return this.val$immutability;
            }

            public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener> getSpecificationProvider() {
                return SpringSpecificationProvider.INSTANCE;
            }
        });
        this.stopTasks.add(() -> ((SessionManagerFactory)managerFactory).close());
        final Supplier factory = this.configuration.getIdentifierFactory();
        IdentifierFactory<String> identifierFactory = new IdentifierFactory<String>(){

            public String createIdentifier() {
                return (String)factory.get();
            }

            public void start() {
            }

            public void stop() {
            }
        };
        Map indexes = this.configuration.getIndexes();
        final HashMap<String, SSOManager> managers = indexes.isEmpty() ? Collections.emptyMap() : new HashMap<String, SSOManager>();
        for (Map.Entry entry : indexes.entrySet()) {
            String cacheName = String.format("%s/%s", deploymentName, entry.getKey());
            String indexName = (String)entry.getValue();
            configuration.addRemoteCache(cacheName, builder -> builder.forceReturnValues(false).nearCacheMode(NearCacheMode.DISABLED).transactionMode(TransactionMode.NONE).templateName(templateName));
            HotRodSSOManagerFactory ssoManagerFactory = new HotRodSSOManagerFactory(new HotRodSSOManagerFactoryConfiguration((RemoteCacheContainer)container, cacheName){
                final /* synthetic */ RemoteCacheContainer val$container;
                final /* synthetic */ String val$cacheName;
                {
                    this.val$container = remoteCacheContainer;
                    this.val$cacheName = string;
                }

                public <K, V> RemoteCache<K, V> getRemoteCache() {
                    return this.val$container.getCache(this.val$cacheName);
                }
            });
            SSOManager ssoManager = ssoManagerFactory.createSSOManager((SSOManagerConfiguration)new SSOManagerConfiguration<ByteBufferMarshaller, Void>((IdentifierFactory)identifierFactory, (MarshalledValueFactory)marshalledValueFactory){
                final /* synthetic */ IdentifierFactory val$identifierFactory;
                final /* synthetic */ MarshalledValueFactory val$marshalledValueFactory;
                {
                    this.val$identifierFactory = identifierFactory;
                    this.val$marshalledValueFactory = marshalledValueFactory;
                }

                public IdentifierFactory<String> getIdentifierFactory() {
                    return this.val$identifierFactory;
                }

                public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                    return this.val$marshalledValueFactory;
                }

                public LocalContextFactory<Void> getLocalContextFactory() {
                    return HotRodSessionRepository.this;
                }
            });
            managers.put(indexName, ssoManager);
        }
        final IndexResolver resolver = this.configuration.getIndexResolver();
        IndexingConfiguration<TransactionBatch> indexing = new IndexingConfiguration<TransactionBatch>(){

            public Map<String, SSOManager<Void, String, String, Void, TransactionBatch>> getSSOManagers() {
                return managers;
            }

            public IndexResolver<Session> getIndexResolver() {
                return resolver;
            }
        };
        final ApplicationEventPublisher publisher = this.configuration.getEventPublisher();
        ImmutableSessionDestroyAction sessionDestroyAction = new ImmutableSessionDestroyAction(publisher, context, (IndexingConfiguration)indexing);
        ImmutableSessionExpirationListener expirationListener = new ImmutableSessionExpirationListener(context, (BiConsumer)sessionDestroyAction);
        final SessionManager manager = managerFactory.createSessionManager((SessionManagerConfiguration)new SessionManagerConfiguration<ServletContext>((IdentifierFactory)identifierFactory, (SessionExpirationListener)expirationListener){
            final /* synthetic */ IdentifierFactory val$identifierFactory;
            final /* synthetic */ SessionExpirationListener val$expirationListener;
            {
                this.val$identifierFactory = identifierFactory;
                this.val$expirationListener = sessionExpirationListener;
            }

            public ServletContext getServletContext() {
                return context;
            }

            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionExpirationListener getExpirationListener() {
                return this.val$expirationListener;
            }

            public Recordable<ImmutableSessionMetaData> getInactiveSessionRecorder() {
                return null;
            }
        });
        final Optional<Duration> defaultTimeout = HotRodSessionRepository.setDefaultMaxInactiveInterval((SessionManager<Void, TransactionBatch>)manager, Duration.ofMinutes(context.getSessionTimeout()));
        manager.start();
        this.stopTasks.add(() -> ((SessionManager)manager).stop());
        this.repository = new DistributableSessionRepository((DistributableSessionRepositoryConfiguration)new DistributableSessionRepositoryConfiguration<TransactionBatch>((BiConsumer)sessionDestroyAction, (IndexingConfiguration)indexing){
            final /* synthetic */ BiConsumer val$sessionDestroyAction;
            final /* synthetic */ IndexingConfiguration val$indexing;
            {
                this.val$sessionDestroyAction = biConsumer;
                this.val$indexing = indexingConfiguration;
            }

            public SessionManager<Void, TransactionBatch> getSessionManager() {
                return manager;
            }

            public Optional<Duration> getDefaultTimeout() {
                return defaultTimeout;
            }

            public ApplicationEventPublisher getEventPublisher() {
                return publisher;
            }

            public ServletContext getServletContext() {
                return context;
            }

            public BiConsumer<ImmutableSession, BiFunction<Object, Session, ApplicationEvent>> getSessionDestroyAction() {
                return this.val$sessionDestroyAction;
            }

            public IndexingConfiguration<TransactionBatch> getIndexingConfiguration() {
                return this.val$indexing;
            }
        });
    }

    private static Optional<Duration> setDefaultMaxInactiveInterval(SessionManager<Void, TransactionBatch> manager, Duration timeout) {
        try {
            manager.setDefaultMaxInactiveInterval(timeout);
            return Optional.empty();
        }
        catch (NoSuchMethodError error) {
            return Optional.of(timeout);
        }
    }

    public void destroy() throws Exception {
        ListIterator<Runnable> tasks = this.stopTasks.listIterator(this.stopTasks.size() - 1);
        while (tasks.hasPrevious()) {
            tasks.previous().run();
        }
    }

    public Registration register(String name) {
        return this;
    }

    public void close() {
    }

    public Void createLocalContext() {
        return null;
    }

    public SpringSession createSession() {
        return (SpringSession)this.repository.createSession();
    }

    public SpringSession findById(String id) {
        return (SpringSession)this.repository.findById(id);
    }

    public void deleteById(String id) {
        this.repository.deleteById(id);
    }

    public void save(SpringSession session) {
        this.repository.save((Session)session);
    }

    public Map<String, SpringSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        return this.repository.findByIndexNameAndIndexValue(indexName, indexValue);
    }
}

