/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.hotrod;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.marshall.Marshaller;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.IndexResolver;
import org.springframework.session.Session;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.SimpleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactory;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.clustering.web.spring.DistributableSessionRepository;
import org.wildfly.clustering.web.spring.DistributableSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.ImmutableSessionDestroyAction;
import org.wildfly.clustering.web.spring.ImmutableSessionExpirationListener;
import org.wildfly.clustering.web.spring.IndexingConfiguration;
import org.wildfly.clustering.web.spring.JakartaSessionManagerConfiguration;
import org.wildfly.clustering.web.spring.SpringSession;
import org.wildfly.clustering.web.spring.SpringSpecificationProvider;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.security.SpringSecurityImmutability;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.common.iteration.CompositeIterable;
import org.wildfly.security.manager.WildFlySecurityManager;

public class HotRodSessionRepository
implements FindByIndexNameSessionRepository<SpringSession>,
InitializingBean,
DisposableBean,
LocalContextFactory<Void> {
    private final HotRodSessionRepositoryConfiguration configuration;
    private final List<Runnable> stopTasks = new LinkedList<Runnable>();
    private volatile FindByIndexNameSessionRepository<SpringSession> repository;

    public HotRodSessionRepository(HotRodSessionRepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        final ServletContext context = this.configuration.getServletContext();
        final String deploymentName = context.getVirtualServerName() + context.getContextPath();
        String templateName = this.configuration.getTemplateName();
        final Integer maxActiveSessions = this.configuration.getMaxActiveSessions();
        final SessionAttributePersistenceStrategy strategy = this.configuration.getPersistenceStrategy();
        ClassLoader containerLoader = WildFlySecurityManager.getClassLoaderPrivileged(HotRodSessionManagerFactory.class);
        URI uri = this.configuration.getUri();
        Configuration configuration = (uri != null ? HotRodURI.create((URI)uri).toConfigurationBuilder() : new ConfigurationBuilder()).withProperties(this.configuration.getProperties()).marshaller((Marshaller)new ProtoStreamMarshaller((ClassLoaderMarshaller)new SimpleClassLoaderMarshaller(containerLoader), builder -> builder.load(containerLoader))).classLoader(containerLoader).asyncExecutorFactory().factory(new ExecutorFactory(){

            public ThreadPoolExecutor getExecutor(Properties p) {
                ConfigurationProperties properties = new ConfigurationProperties(p);
                final String threadNamePrefix = properties.getDefaultExecutorFactoryThreadNamePrefix();
                final String threadNameSuffix = properties.getDefaultExecutorFactoryThreadNameSuffix();
                final NonBlockingThreadGroup group = new NonBlockingThreadGroup(threadNamePrefix + "-group");
                ThreadFactory factory = new ThreadFactory(){
                    private final AtomicInteger counter = new AtomicInteger(0);

                    @Override
                    public Thread newThread(Runnable task) {
                        int threadIndex = this.counter.incrementAndGet();
                        Thread thread = new Thread(group, task, threadNamePrefix + "-" + threadIndex + threadNameSuffix);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                return new ThreadPoolExecutor(properties.getDefaultExecutorFactoryPoolSize(), properties.getDefaultExecutorFactoryPoolSize(), 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(factory, HotRodSessionRepository.class));
            }
        }).build();
        configuration.addRemoteCache(deploymentName, builder -> builder.forceReturnValues(false).nearCacheMode(maxActiveSessions == null || maxActiveSessions <= 0 ? NearCacheMode.DISABLED : NearCacheMode.INVALIDATED).transactionMode(TransactionMode.NONE).templateName(templateName));
        RemoteCacheManager container = new RemoteCacheManager(configuration);
        container.start();
        this.stopTasks.add(() -> ((RemoteCacheContainer)container).stop());
        ClassLoader loader = context.getClassLoader();
        final ByteBufferMarshaller marshaller = (ByteBufferMarshaller)this.configuration.getMarshallerFactory().apply(loader);
        LinkedList<Immutability> loadedImmutabilities = new LinkedList<Immutability>();
        for (Immutability loadedImmutability : ServiceLoader.load(Immutability.class, loader)) {
            loadedImmutabilities.add(loadedImmutability);
        }
        CompositeImmutability immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), EnumSet.allOf(SpringSecurityImmutability.class), loadedImmutabilities}));
        HotRodSessionManagerFactory managerFactory = new HotRodSessionManagerFactory((HotRodSessionManagerFactoryConfiguration)new HotRodSessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, Void>(){
            final /* synthetic */ RemoteCacheContainer val$container;
            final /* synthetic */ Immutability val$immutability;
            {
                this.val$container = remoteCacheContainer;
                this.val$immutability = immutability;
            }

            public Integer getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public ByteBufferMarshaller getMarshaller() {
                return marshaller;
            }

            public String getServerName() {
                return context.getVirtualServerName();
            }

            public LocalContextFactory<Void> getLocalContextFactory() {
                return HotRodSessionRepository.this;
            }

            public <K, V> RemoteCache<K, V> getCache() {
                return this.val$container.getCache(this.getDeploymentName());
            }

            public Immutability getImmutability() {
                return this.val$immutability;
            }

            public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener> getSpecificationProvider() {
                return SpringSpecificationProvider.INSTANCE;
            }
        });
        this.stopTasks.add(() -> ((SessionManagerFactory)managerFactory).close());
        final Supplier identifierFactory = this.configuration.getIdentifierFactory();
        Map indexes = this.configuration.getIndexes();
        final HashMap<String, SSOManager> managers = indexes.isEmpty() ? Collections.emptyMap() : new HashMap<String, SSOManager>();
        for (Map.Entry entry : indexes.entrySet()) {
            String cacheName = String.format("%s/%s", deploymentName, entry.getKey());
            String indexName = (String)entry.getValue();
            configuration.addRemoteCache(cacheName, builder -> builder.forceReturnValues(false).nearCacheMode(NearCacheMode.DISABLED).transactionMode(TransactionMode.NONE).templateName(templateName));
            HotRodSSOManagerFactory ssoManagerFactory = new HotRodSSOManagerFactory(new HotRodSSOManagerFactoryConfiguration(){
                final /* synthetic */ RemoteCacheContainer val$container;
                final /* synthetic */ String val$cacheName;
                {
                    this.val$container = remoteCacheContainer;
                    this.val$cacheName = string;
                }

                public <K, V> RemoteCache<K, V> getRemoteCache() {
                    return this.val$container.getCache(this.val$cacheName);
                }
            });
            SSOManager ssoManager = ssoManagerFactory.createSSOManager((SSOManagerConfiguration)new SSOManagerConfiguration<Void>(){

                public Supplier<String> getIdentifierFactory() {
                    return identifierFactory;
                }

                public ByteBufferMarshaller getMarshaller() {
                    return marshaller;
                }

                public LocalContextFactory<Void> getLocalContextFactory() {
                    return HotRodSessionRepository.this;
                }
            });
            managers.put(indexName, ssoManager);
        }
        final IndexResolver resolver = this.configuration.getIndexResolver();
        IndexingConfiguration<TransactionBatch> indexing = new IndexingConfiguration<TransactionBatch>(){

            public Map<String, SSOManager<Void, String, String, Void, TransactionBatch>> getSSOManagers() {
                return managers;
            }

            public IndexResolver<Session> getIndexResolver() {
                return resolver;
            }
        };
        final ApplicationEventPublisher publisher = this.configuration.getEventPublisher();
        ImmutableSessionDestroyAction sessionDestroyAction = new ImmutableSessionDestroyAction(publisher, context, (IndexingConfiguration)indexing);
        ImmutableSessionExpirationListener expirationListener = new ImmutableSessionExpirationListener(context, (BiConsumer)sessionDestroyAction);
        JakartaSessionManagerConfiguration managerConfiguration = new JakartaSessionManagerConfiguration(){
            final /* synthetic */ Consumer val$expirationListener;
            {
                this.val$expirationListener = consumer;
            }

            public ServletContext getServletContext() {
                return context;
            }

            public Supplier<String> getIdentifierFactory() {
                return identifierFactory;
            }

            public Consumer<ImmutableSession> getExpirationListener() {
                return this.val$expirationListener;
            }
        };
        final SessionManager manager = managerFactory.createSessionManager((SessionManagerConfiguration)managerConfiguration);
        manager.start();
        this.stopTasks.add(() -> ((SessionManager)manager).stop());
        this.repository = new DistributableSessionRepository((DistributableSessionRepositoryConfiguration)new DistributableSessionRepositoryConfiguration<TransactionBatch>(){
            final /* synthetic */ BiConsumer val$sessionDestroyAction;
            final /* synthetic */ IndexingConfiguration val$indexing;
            {
                this.val$sessionDestroyAction = biConsumer;
                this.val$indexing = indexingConfiguration;
            }

            public SessionManager<Void, TransactionBatch> getSessionManager() {
                return manager;
            }

            public ApplicationEventPublisher getEventPublisher() {
                return publisher;
            }

            public BiConsumer<ImmutableSession, BiFunction<Object, Session, ApplicationEvent>> getSessionDestroyAction() {
                return this.val$sessionDestroyAction;
            }

            public IndexingConfiguration<TransactionBatch> getIndexingConfiguration() {
                return this.val$indexing;
            }
        });
    }

    public void destroy() throws Exception {
        ListIterator<Runnable> tasks = this.stopTasks.listIterator(this.stopTasks.size() - 1);
        while (tasks.hasPrevious()) {
            tasks.previous().run();
        }
    }

    public Void createLocalContext() {
        return null;
    }

    public SpringSession createSession() {
        return (SpringSession)this.repository.createSession();
    }

    public SpringSession findById(String id) {
        return (SpringSession)this.repository.findById(id);
    }

    public void deleteById(String id) {
        this.repository.deleteById(id);
    }

    public void save(SpringSession session) {
        this.repository.save((Session)session);
    }

    public Map<String, SpringSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        return this.repository.findByIndexNameAndIndexValue(indexName, indexValue);
    }

    static class NonBlockingThreadGroup
    extends ThreadGroup
    implements NonBlockingResource {
        NonBlockingThreadGroup(String name) {
            super(name);
        }
    }
}

