/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.session.infinispan.embedded;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.UnaryOperator;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.wildfly.clustering.spring.session.authentication.SecurityInitializer;
import org.wildfly.clustering.spring.session.infinispan.embedded.AbstractInfinispanSessionSmokeITCase;
import org.wildfly.clustering.spring.session.infinispan.embedded.authentication.ConfigContextLoaderListener;
import org.wildfly.clustering.spring.session.servlet.SessionServlet;

@ExtendWith(value={ArquillianExtension.class})
public class InfinispanSessionAuthSmokeITCase
extends AbstractInfinispanSessionSmokeITCase {
    @ArquillianResource(value=SessionServlet.class)
    @OperateOnDeployment(value="deployment-1")
    private URI baseURI1;
    @ArquillianResource(value=SessionServlet.class)
    @OperateOnDeployment(value="deployment-2")
    private URI baseURI2;

    @Deployment(name="deployment-1", testable=false)
    @TargetsContainer(value="tomcat-1")
    public static Archive<?> deployment1() {
        return InfinispanSessionAuthSmokeITCase.deployment();
    }

    @Deployment(name="deployment-2", testable=false)
    @TargetsContainer(value="tomcat-2")
    public static Archive<?> deployment2() {
        return InfinispanSessionAuthSmokeITCase.deployment();
    }

    private static Archive<?> deployment() {
        return ((WebArchive)InfinispanSessionAuthSmokeITCase.deployment(InfinispanSessionAuthSmokeITCase.class).addPackage(ConfigContextLoaderListener.class.getPackage())).addPackage(SecurityInitializer.class.getPackage());
    }

    public UnaryOperator<HttpClient.Builder> getHttpClientConfigurator() {
        return builder -> builder.authenticator(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("admin", "password".toCharArray());
            }
        });
    }

    @Test
    @RunAsClient
    public void test() throws Exception {
        URI uri1 = this.baseURI1.resolve("session");
        HttpResponse<Void> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder(uri1).build(), HttpResponse.BodyHandlers.discarding());
        Assertions.assertEquals((int)401, (int)response.statusCode());
        this.accept(this.baseURI1, this.baseURI2);
    }
}

