/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.session.infinispan.embedded;

import jakarta.servlet.ServletContext;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.session.IndexResolver;
import org.springframework.session.Session;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheContainerConfiguration;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.user.InfinispanUserManagerFactory;
import org.wildfly.clustering.session.user.UserManager;
import org.wildfly.clustering.session.user.UserManagerConfiguration;
import org.wildfly.clustering.spring.context.AutoDestroyBean;
import org.wildfly.clustering.spring.session.IndexingConfiguration;
import org.wildfly.clustering.spring.session.UserConfiguration;
import org.wildfly.common.function.Functions;

public class UserConfigurationBean
extends AutoDestroyBean
implements UserConfiguration,
InitializingBean {
    private final Map<String, UserManager<Void, Void, String, String>> managers = new TreeMap<String, UserManager<Void, Void, String, String>>();
    private final SessionManagerFactoryConfiguration<Void> sessionManagerFactoryConfiguration;
    private final SessionManagerConfiguration<ServletContext> sessionManagerConfiguration;
    private final IndexingConfiguration indexing;
    private final EmbeddedCacheContainerConfiguration infinispan;

    public UserConfigurationBean(SessionManagerFactoryConfiguration<Void> managerFactoryConfiguration, SessionManagerConfiguration<ServletContext> managerConfiguration, IndexingConfiguration indexing, EmbeddedCacheContainerConfiguration infinispan) {
        this.sessionManagerFactoryConfiguration = managerFactoryConfiguration;
        this.sessionManagerConfiguration = managerConfiguration;
        this.indexing = indexing;
        this.infinispan = infinispan;
    }

    public void afterPropertiesSet() throws Exception {
        final EmbeddedCacheManager container = this.infinispan.getCacheContainer();
        String applicationName = this.sessionManagerFactoryConfiguration.getDeploymentName();
        for (Map.Entry entry : this.indexing.getIndexes().entrySet()) {
            final String cacheName = String.format("%s/%s", applicationName, entry.getKey());
            String indexName = (String)entry.getValue();
            ConfigurationBuilder builder = new ConfigurationBuilder().read(container.getCacheConfiguration(applicationName));
            container.defineConfiguration(cacheName, builder.build());
            this.accept(() -> container.undefineConfiguration(cacheName));
            Cache cache = container.getCache(cacheName);
            cache.start();
            this.accept(() -> ((Cache)cache).stop());
            EmbeddedCacheConfiguration cacheConfiguration = new EmbeddedCacheConfiguration(){
                final /* synthetic */ UserConfigurationBean this$0;
                {
                    this.this$0 = this$0;
                }

                public <K, V> Cache<K, V> getCache() {
                    return container.getCache(cacheName);
                }
            };
            InfinispanUserManagerFactory userManagerFactory = new InfinispanUserManagerFactory(cacheConfiguration);
            UserManager userManager = userManagerFactory.createUserManager((UserManagerConfiguration)new UserManagerConfiguration<Void>(){

                public Supplier<String> getIdentifierFactory() {
                    return UserConfigurationBean.this.sessionManagerConfiguration.getIdentifierFactory();
                }

                public ByteBufferMarshaller getMarshaller() {
                    return UserConfigurationBean.this.sessionManagerFactoryConfiguration.getMarshaller();
                }

                public Supplier<Void> getTransientContextFactory() {
                    return Functions.constantSupplier(null);
                }
            });
            this.managers.put(indexName, (UserManager<Void, Void, String, String>)userManager);
        }
    }

    public Map<String, UserManager<Void, Void, String, String>> getUserManagers() {
        return this.managers;
    }

    public IndexResolver<Session> getIndexResolver() {
        return this.indexing.getIndexResolver();
    }
}

