/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spring.session.infinispan.remote;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.assertj.core.api.Assertions;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.arquillian.Deployment;
import org.wildfly.clustering.session.container.SessionManagementTester;
import org.wildfly.clustering.session.container.SessionManagementTesterConfiguration;
import org.wildfly.clustering.spring.context.PropertiesAsset;
import org.wildfly.clustering.spring.session.authentication.SecurityInitializer;
import org.wildfly.clustering.spring.session.infinispan.remote.AbstractHotRodSessionManagerITCase;
import org.wildfly.clustering.spring.session.infinispan.remote.authentication.Config;

public class AuthenticationHotRodSessionManagerITCase
extends AbstractHotRodSessionManagerITCase {
    public AuthenticationHotRodSessionManagerITCase() {
        super(configuration -> new SessionManagementTester((SessionManagementTesterConfiguration)configuration, (SessionManagementTesterConfiguration)configuration){
            final /* synthetic */ SessionManagementTesterConfiguration val$configuration;
            {
                this.val$configuration = sessionManagementTesterConfiguration;
                super(configuration);
            }

            public void accept(List<Deployment> deployments) {
                List<URI> endpoints = deployments.stream().map(arg_0 -> ((SessionManagementTesterConfiguration)this.val$configuration).locateEndpoint(arg_0)).toList();
                try {
                    for (URI endpoint : endpoints) {
                        HttpResponse<Void> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder(endpoint).method(SessionManagementTester.HttpMethod.HEAD.name(), HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.discarding());
                        Assertions.assertThat((int)response.statusCode()).isEqualTo(401);
                    }
                    super.accept(deployments);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    Assertions.fail((Throwable)e);
                }
            }
        }, new AbstractHotRodSessionManagerITCase.SessionManagementTesterConfiguration(){

            public UnaryOperator<HttpClient.Builder> getHttpClientConfigurator() {
                return builder -> builder.authenticator(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("admin", "password".toCharArray());
                    }
                });
            }
        });
    }

    @Override
    public WebArchive createArchive(SessionManagementTesterConfiguration configuration) {
        return (WebArchive)((WebArchive)((WebArchive)super.createArchive(configuration).addAsWebInfResource((Asset)new PropertiesAsset(this.apply(new Properties())), "classes/application.properties")).addPackage(Config.class.getPackage())).addPackage(SecurityInitializer.class.getPackage());
    }

    @Test
    public void test() {
        this.run();
    }
}

