/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionContext;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.catalina.Context;
import org.apache.catalina.valves.CrawlerSessionManagerValve;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.web.session.Session;

public class HttpSessionAdapter<B extends Batch>
implements HttpSession {
    private static final Set<String> EXCLUDED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("javax.security.auth.subject", "org.apache.catalina.realm.GSS_CREDENTIAL", CrawlerSessionManagerValve.class.getName())));
    private final Session<LocalSessionContext> session;
    private final CatalinaManager<B> manager;
    private final B batch;
    private final Runnable invalidateAction;

    public HttpSessionAdapter(Session<LocalSessionContext> session, CatalinaManager<B> manager, B batch, Runnable invalidateAction) {
        this.session = session;
        this.manager = manager;
        this.batch = batch;
        this.invalidateAction = invalidateAction;
    }

    public boolean isNew() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            boolean bl = this.session.getMetaData().isNew();
            return bl;
        }
    }

    public long getCreationTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = this.session.getMetaData().getCreationTime().toEpochMilli();
            return l;
        }
    }

    public long getLastAccessedTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = this.session.getMetaData().getLastAccessStartTime().toEpochMilli();
            return l;
        }
    }

    public int getMaxInactiveInterval() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            int n = (int)this.session.getMetaData().getMaxInactiveInterval().getSeconds();
            return n;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            this.session.getMetaData().setMaxInactiveInterval(interval > 0 ? Duration.ofSeconds(interval) : Duration.ZERO);
        }
    }

    public void invalidate() {
        this.invalidateAction.run();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            this.session.invalidate();
            this.batch.close();
        }
    }

    public Object getAttribute(String name) {
        if (EXCLUDED_ATTRIBUTES.contains(name)) {
            return ((LocalSessionContext)this.session.getLocalContext()).getNotes().get(name);
        }
        ((LocalSessionContext)this.session.getLocalContext()).getNotes().get(name);
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            Object object = this.session.getAttributes().getAttribute(name);
            return object;
        }
    }

    public Enumeration<String> getAttributeNames() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            Enumeration<String> enumeration = Collections.enumeration(this.session.getAttributes().getAttributeNames());
            return enumeration;
        }
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            if (EXCLUDED_ATTRIBUTES.contains(name)) {
                ((LocalSessionContext)this.session.getLocalContext()).getNotes().put(name, value);
            } else {
                Object old = null;
                try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
                    old = this.session.getAttributes().setAttribute(name, value);
                }
                if (old != value) {
                    this.notifySessionAttributeListeners(name, old, value);
                }
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        if (EXCLUDED_ATTRIBUTES.contains(name)) {
            ((LocalSessionContext)this.session.getLocalContext()).getNotes().remove(name);
        } else {
            Object value = null;
            try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
                value = this.session.getAttributes().removeAttribute(name);
            }
            if (value != null) {
                this.notifySessionAttributeListeners(name, value, null);
            }
        }
    }

    private void notifySessionAttributeListeners(String name, Object oldValue, Object newValue) {
        HttpSessionBindingListener listener;
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            try {
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        if (newValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)newValue;
            try {
                listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue != null ? oldValue : newValue);
        AttributeEventType type = oldValue == null ? AttributeEventType.ADDED : (newValue == null ? AttributeEventType.REMOVED : AttributeEventType.REPLACED);
        type.accept(this.manager.getContext(), event);
    }

    public String getId() {
        return this.session.getId();
    }

    public ServletContext getServletContext() {
        return this.manager.getContext().getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return new HttpSessionContext(){

            public HttpSession getSession(String sessionId) {
                throw null;
            }

            public Enumeration<String> getIds() {
                return Collections.enumeration(Collections.emptyList());
            }
        };
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return Collections.list(this.getAttributeNames()).toArray(new String[0]);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    static enum AttributeEventType implements BiConsumer<Context, HttpSessionBindingEvent>
    {
        ADDED("beforeSessionAttributeAdded", "afterSessionAttributeAdded", (listener, event) -> listener.attributeAdded(event)),
        REMOVED("beforeSessionAttributeRemoved", "afterSessionAttributeRemoved", (listener, event) -> listener.attributeRemoved(event)),
        REPLACED("beforeSessionAttributeReplaced", "afterSessionAttributeReplaced", (listener, event) -> listener.attributeReplaced(event));

        private final String beforeEvent;
        private final String afterEvent;
        private final BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger;

        private AttributeEventType(String beforeEvent, String afterEvent, BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger) {
            this.beforeEvent = beforeEvent;
            this.afterEvent = afterEvent;
            this.trigger = trigger;
        }

        @Override
        public void accept(Context context, HttpSessionBindingEvent event) {
            Stream.of(context.getApplicationEventListeners()).filter(HttpSessionAttributeListener.class::isInstance).map(HttpSessionAttributeListener.class::cast).forEach(listener -> {
                try {
                    context.fireContainerEvent(this.beforeEvent, listener);
                    this.trigger.accept((HttpSessionAttributeListener)listener, event);
                }
                catch (Throwable e) {
                    context.getLogger().warn((Object)e.getMessage(), e);
                }
                finally {
                    context.fireContainerEvent(this.afterEvent, listener);
                }
            });
        }
    }
}

