/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.catalina.Context;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;

public class CatalinaSessionDestroyAction
implements Consumer<ImmutableSession> {
    private final Context context;

    public CatalinaSessionDestroyAction(Context context) {
        this.context = context;
    }

    @Override
    public void accept(ImmutableSession session) {
        HttpSessionEvent event = new HttpSessionEvent(HttpSessionProvider.INSTANCE.asSession(session, this.context.getServletContext()));
        Stream.of(this.context.getApplicationLifecycleListeners()).filter(HttpSessionListener.class::isInstance).map(HttpSessionListener.class::cast).forEach(listener -> {
            try {
                this.context.fireContainerEvent("beforeSessionDestroyed", listener);
                listener.sessionDestroyed(event);
            }
            catch (Throwable e) {
                this.context.getLogger().warn((Object)e.getMessage(), e);
            }
            finally {
                this.context.fireContainerEvent("afterSessionDestroyed", listener);
            }
        });
        for (Map.Entry entry : session.getAttributes().entrySet()) {
            if (!(entry.getValue() instanceof HttpSessionBindingListener)) continue;
            HttpSessionBindingListener listener2 = (HttpSessionBindingListener)entry.getValue();
            try {
                listener2.valueUnbound(new HttpSessionBindingEvent(event.getSession(), (String)entry.getKey(), (Object)listener2));
            }
            catch (Throwable e) {
                this.context.getLogger().warn((Object)e.getMessage(), e);
            }
        }
    }
}

