/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.marshalling.Marshallability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionContext;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionDestroyAction;
import org.wildfly.clustering.tomcat.catalina.DistributableSession;

public class DistributableManager
implements CatalinaManager {
    private static final char ROUTE_DELIMITER = '.';
    private final SessionManager<CatalinaSessionContext> manager;
    private final UnaryOperator<String> affinity;
    private final Context context;
    private final Consumer<ImmutableSession> invalidateAction;
    private final Marshallability marshallability;

    public DistributableManager(SessionManager<CatalinaSessionContext> manager, UnaryOperator<String> affinity, Context context, Marshallability marshallability) {
        this.manager = manager;
        this.affinity = affinity;
        this.marshallability = marshallability;
        this.context = context;
        this.invalidateAction = new CatalinaSessionDestroyAction(context);
    }

    @Override
    public SessionManager<CatalinaSessionContext> getSessionManager() {
        return this.manager;
    }

    @Override
    public Marshallability getMarshallability() {
        return this.marshallability;
    }

    private static String parseSessionId(String requestedSesssionId) {
        int index = requestedSesssionId.indexOf(46);
        return index < 0 ? requestedSesssionId : requestedSesssionId.substring(0, index);
    }

    private Session getSession(org.wildfly.clustering.session.Session<CatalinaSessionContext> session, Batch batch) {
        String id = session.getId();
        String route = (String)this.affinity.apply(id);
        String internalId = new StringBuilder(id.length() + route.length() + 1).append(id).append('.').append(route).toString();
        return new DistributableSession(this, session, internalId, batch.suspend(), () -> this.invalidateAction.accept((ImmutableSession)session));
    }

    @Override
    public void start() {
        this.manager.start();
    }

    @Override
    public void stop() {
        this.manager.stop();
    }

    public Session createSession(String sessionId) {
        String id = sessionId != null ? DistributableManager.parseSessionId(sessionId) : (String)this.manager.getIdentifierFactory().get();
        boolean close = true;
        Batch batch = (Batch)this.manager.getBatchFactory().get();
        try {
            org.wildfly.clustering.session.Session session = this.manager.createSession(id);
            HttpSessionEvent event = new HttpSessionEvent(HttpSessionProvider.INSTANCE.asSession((ImmutableSession)session, this.context.getServletContext()));
            Stream.of(this.context.getApplicationLifecycleListeners()).filter(HttpSessionListener.class::isInstance).map(HttpSessionListener.class::cast).forEach(listener -> {
                try {
                    this.context.fireContainerEvent("beforeSessionCreated", listener);
                    listener.sessionCreated(event);
                }
                catch (Throwable e) {
                    this.context.getLogger().warn((Object)e.getMessage(), e);
                }
                finally {
                    this.context.fireContainerEvent("afterSessionCreated", listener);
                }
            });
            Session result = this.getSession((org.wildfly.clustering.session.Session<CatalinaSessionContext>)session, batch);
            close = false;
            Session session2 = result;
            return session2;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }

    public Session findSession(String sessionId) throws IOException {
        String id = DistributableManager.parseSessionId(sessionId);
        boolean close = true;
        Batch batch = (Batch)this.manager.getBatchFactory().get();
        try {
            org.wildfly.clustering.session.Session session = this.manager.findSession(id);
            if (session == null) {
                Session session2 = null;
                return session2;
            }
            Session result = this.getSession((org.wildfly.clustering.session.Session<CatalinaSessionContext>)session, batch);
            close = false;
            Session session3 = result;
            return session3;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }

    public void changeSessionId(Session session, String id) {
        session.tellChangedSessionId(id, session.getId(), true, true);
    }

    public Context getContext() {
        return this.context;
    }

    public boolean willAttributeDistribute(String name, Object value) {
        return this.marshallability.isMarshallable(value);
    }

    public boolean getNotifyAttributeListenerOnUnchangedValue() {
        return false;
    }
}

