/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina.authenticator;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.security.Principal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserManager;
import org.wildfly.clustering.tomcat.catalina.authenticator.AuthenticationType;
import org.wildfly.clustering.tomcat.catalina.authenticator.Credentials;
import org.wildfly.clustering.tomcat.catalina.authenticator.ManagerRegistry;
import org.wildfly.clustering.tomcat.catalina.authenticator.TransientUserContext;

public class DistributableSingleSignOn
extends SingleSignOn
implements ManagerRegistry,
LifecycleListener {
    private final ConcurrentMap<String, Manager> managers = new ConcurrentHashMap<String, Manager>();
    private final UserManager<Credentials, TransientUserContext, String, String> manager;

    public DistributableSingleSignOn(UserManager<Credentials, TransientUserContext, String, String> manager) {
        this.manager = manager;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        try (Batch batch = (Batch)this.manager.getBatchFactory().get();){
            super.invoke(request, response);
        }
    }

    @Override
    public Manager getManager(String deployment) {
        return (Manager)this.managers.get(deployment);
    }

    protected void removeSession(String ssoId, Session session) {
        User sso = this.manager.findUser(ssoId);
        if (sso != null) {
            sso.getSessions().removeSession((Object)DistributableSingleSignOn.getDeployment(session.getManager()));
            if (sso.getSessions().getDeployments().isEmpty()) {
                sso.invalidate();
            }
        }
    }

    public boolean associate(String ssoId, Session session) {
        Manager manager = session.getManager();
        String deployment = DistributableSingleSignOn.getDeployment(manager);
        User sso = this.manager.findUser(ssoId);
        if (sso != null) {
            sso.getSessions().addSession((Object)deployment, (Object)session.getId());
        }
        if (this.managers.putIfAbsent(deployment, manager) == null) {
            ((Lifecycle)manager).addLifecycleListener((LifecycleListener)this);
        }
        return sso != null;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source;
        Manager manager;
        String type = event.getType();
        if ("stop".equals(type) && this.managers.remove(DistributableSingleSignOn.getDeployment(manager = (Manager)(source = event.getLifecycle()))) != null) {
            source.removeLifecycleListener((LifecycleListener)this);
        }
    }

    public void deregister(String ssoId) {
        User sso = this.manager.findUser(ssoId);
        if (sso != null) {
            sso.invalidate();
        }
    }

    public void register(String ssoId, Principal principal, String authType, String username, String password) {
        Credentials credentials = new Credentials();
        credentials.setAuthenticationType(AuthenticationType.valueOf(authType));
        credentials.setUser(username);
        credentials.setPassword(password);
        User sso = this.manager.createUser(ssoId, (Object)credentials);
        ((TransientUserContext)sso.getTransientContext()).setPrincipal(principal);
    }

    public boolean update(String ssoId, Principal principal, String authType, String username, String password) {
        User user = this.manager.findUser(ssoId);
        if (user == null) {
            return false;
        }
        ((TransientUserContext)user.getTransientContext()).setPrincipal(principal);
        Credentials credentials = (Credentials)user.getPersistentContext();
        credentials.setAuthenticationType(AuthenticationType.valueOf(authType));
        credentials.setUser(username);
        credentials.setPassword(password);
        return true;
    }

    private static String getDeployment(Manager manager) {
        Context context = manager.getContext();
        Host host = (Host)context.getParent();
        return host.getName() + context.getName();
    }
}

