/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.security.Principal;
import java.time.Duration;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.SessionListener;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSession;
import org.wildfly.clustering.tomcat.catalina.HttpSessionAdapter;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;

public class DistributableSession<B extends Batch>
implements CatalinaSession {
    private final CatalinaManager<B> manager;
    private final String internalId;
    private final B batch;
    private final Runnable invalidateAction;
    private final Runnable closeTask;
    private volatile Session<LocalSessionContext> session;

    public DistributableSession(CatalinaManager<B> manager, Session<LocalSessionContext> session, String internalId, B batch, Runnable invalidateAction, Runnable closeTask) {
        this.manager = manager;
        this.session = session;
        this.internalId = internalId;
        this.batch = batch;
        this.invalidateAction = invalidateAction;
        this.closeTask = closeTask;
    }

    public String getAuthType() {
        return ((LocalSessionContext)this.session.getLocalContext()).getAuthType();
    }

    public void setAuthType(String authType) {
        ((LocalSessionContext)this.session.getLocalContext()).setAuthType(authType);
    }

    public long getCreationTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = this.session.getMetaData().getCreationTime().toEpochMilli();
            return l;
        }
    }

    public String getId() {
        return this.session.getId();
    }

    public String getIdInternal() {
        return this.internalId;
    }

    public long getLastAccessedTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = this.session.getMetaData().getLastAccessedTime().toEpochMilli();
            return l;
        }
    }

    public Manager getManager() {
        return this.manager;
    }

    public int getMaxInactiveInterval() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            int n = (int)this.session.getMetaData().getMaxInactiveInterval().getSeconds();
            return n;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            this.session.getMetaData().setMaxInactiveInterval(interval > 0 ? Duration.ofSeconds(interval) : Duration.ZERO);
        }
    }

    public Principal getPrincipal() {
        return ((LocalSessionContext)this.session.getLocalContext()).getPrincipal();
    }

    public void setPrincipal(Principal principal) {
        ((LocalSessionContext)this.session.getLocalContext()).setPrincipal(principal);
    }

    public HttpSession getSession() {
        return new HttpSessionAdapter<B>(this.session, this.manager, this.batch, this.invalidateAction);
    }

    public boolean isValid() {
        return this.session.isValid();
    }

    public void addSessionListener(SessionListener listener) {
        ((LocalSessionContext)this.session.getLocalContext()).getSessionListeners().add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAccess() {
        block30: {
            try {
                if (!this.session.isValid()) break block30;
                Batcher batcher = this.manager.getSessionManager().getBatcher();
                try (BatchContext context = batcher.resumeBatch(this.batch);){
                    if (this.batch.getState() == Batch.State.DISCARDED) {
                        this.batch.close();
                    }
                    try (Object batch = this.batch.getState() == Batch.State.CLOSED ? batcher.createBatch() : this.batch;){
                        this.session.close();
                    }
                }
                catch (Throwable e) {
                    this.manager.getContext().getLogger().warn((Object)e.getLocalizedMessage(), e);
                }
            }
            finally {
                this.closeTask.run();
            }
        }
    }

    public void expire() {
        this.session.invalidate();
    }

    public Object getNote(String name) {
        return ((LocalSessionContext)this.session.getLocalContext()).getNotes().get(name);
    }

    public Iterator<String> getNoteNames() {
        return ((LocalSessionContext)this.session.getLocalContext()).getNotes().keySet().iterator();
    }

    public void removeNote(String name) {
        ((LocalSessionContext)this.session.getLocalContext()).getNotes().remove(name);
    }

    public void removeSessionListener(SessionListener listener) {
        ((LocalSessionContext)this.session.getLocalContext()).getSessionListeners().remove(listener);
    }

    public void setNote(String name, Object value) {
        ((LocalSessionContext)this.session.getLocalContext()).getNotes().put(name, value);
    }

    public void tellChangedSessionId(String newId, String oldId, boolean notifySessionListeners, boolean notifyContainerListeners) {
        SessionManager<LocalSessionContext, B> manager = this.manager.getSessionManager();
        Session<LocalSessionContext> oldSession = this.session;
        try (BatchContext context = manager.getBatcher().resumeBatch(this.batch);){
            Session newSession = manager.createSession(newId);
            for (String name : this.session.getAttributes().getAttributeNames()) {
                newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
            }
            newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval());
            newSession.getMetaData().setLastAccessedTime(oldSession.getMetaData().getLastAccessedTime());
            ((LocalSessionContext)newSession.getLocalContext()).setAuthType(((LocalSessionContext)oldSession.getLocalContext()).getAuthType());
            ((LocalSessionContext)newSession.getLocalContext()).setPrincipal(((LocalSessionContext)oldSession.getLocalContext()).getPrincipal());
            this.session = newSession;
            oldSession.invalidate();
        }
        context = this.manager.getContext();
        if (notifyContainerListeners) {
            context.fireContainerEvent("changeSessionId", (Object)new String[]{oldId, newId});
        }
        if (notifySessionListeners) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            Stream.of(context.getApplicationEventListeners()).filter(listener -> listener instanceof HttpSessionIdListener).map(listener -> (HttpSessionIdListener)listener).forEach(arg_0 -> DistributableSession.lambda$tellChangedSessionId$2(event, oldId, (Context)context, arg_0));
        }
    }

    public boolean isAttributeDistributable(String name, Object value) {
        return this.manager.getMarshallability().isMarshallable(value);
    }

    private static /* synthetic */ void lambda$tellChangedSessionId$2(HttpSessionEvent event, String oldId, Context context, HttpSessionIdListener listener) {
        try {
            listener.sessionIdChanged(event, oldId);
        }
        catch (Throwable e) {
            context.getLogger().warn((Object)e.getMessage(), e);
        }
    }
}

