/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.ClassRule;
import org.wildfly.clustering.tomcat.servlet.SessionHandler;

public abstract class AbstractSmokeITCase {
    public static final String CONTAINER_1 = "tomcat-1";
    public static final String CONTAINER_2 = "tomcat-2";
    public static final String DEPLOYMENT_1 = "deployment-1";
    public static final String DEPLOYMENT_2 = "deployment-2";
    @ClassRule
    public static final InfinispanServerRule SERVERS = InfinispanServerRuleBuilder.config((String)"config.xml").runMode(ServerRunMode.EMBEDDED).numServers(1).build();

    public static Archive<?> deployment(Class<? extends AbstractSmokeITCase> testClass, Class<? extends SessionHandler<?, ?>> servletClass) {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(testClass.getSimpleName() + ".war"))).addClass(SessionHandler.class)).addClass(servletClass)).addAsManifestResource(AbstractSmokeITCase.class.getPackage(), "context.xml", "context.xml");
    }

    protected void test(URL baseURL1, URL baseURL2) throws IOException, URISyntaxException {
        URI uri1 = SessionHandler.createURI(baseURL1);
        URI uri2 = SessionHandler.createURI(baseURL2);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String sessionId = null;
            int value = 0;
            for (int i = 0; i < 5; ++i) {
                for (URI uri : Arrays.asList(uri1, uri2)) {
                    CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(uri));
                    Throwable throwable = null;
                    try {
                        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                        Assert.assertEquals((Object)String.valueOf(value++), (Object)response.getFirstHeader("value").getValue());
                        if (sessionId == null) {
                            sessionId = response.getFirstHeader("session-id").getValue();
                            continue;
                        }
                        Assert.assertEquals((Object)sessionId, (Object)response.getFirstHeader("session-id").getValue());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (response == null) continue;
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        response.close();
                    }
                }
            }
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpDelete(uri1));
            Object object = null;
            try {
                Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                Assert.assertEquals(sessionId, (Object)response.getFirstHeader("session-id").getValue());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (response != null) {
                    if (object != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        response.close();
                    }
                }
            }
            response = client.execute((HttpUriRequest)new HttpHead(uri2));
            object = null;
            try {
                Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                Assert.assertFalse((boolean)response.containsHeader("session-id"));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (response != null) {
                    if (object != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
    }
}

