/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat;

import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.wildfly.clustering.session.container.AbstractSessionManagerITCase;
import org.wildfly.clustering.session.container.SessionManagementTesterConfiguration;
import org.wildfly.clustering.tomcat.SessionManagementParameters;
import org.wildfly.clustering.tomcat.SessionMarshallerFactory;
import org.wildfly.clustering.tomcat.SessionPersistenceGranularity;

public abstract class AbstractInfinispanSessionManagerITCase
extends AbstractSessionManagerITCase<WebArchive> {
    private static final String CONTEXT_XML = "\t\t<Context>\n\t\t\t<Manager className=\"%s\" granularity=\"%s\" marshaller=\"%s\"/>\n\t\t</Context>\n";
    private final Class<?> managerClass;
    private SessionManagementParameters parameters;

    protected AbstractInfinispanSessionManagerITCase(Class<?> managerClass, final Class<?> endpointClass) {
        super(new SessionManagementTesterConfiguration(){

            public Class<?> getEndpointClass() {
                return endpointClass;
            }
        }, WebArchive.class);
        this.managerClass = managerClass;
    }

    @ParameterizedTest(name="{arguments}")
    @ArgumentsSource(value=InfinispanSessionManagerArgumentsProvider.class)
    @RunAsClient
    public void test(SessionManagementParameters parameters) throws Exception {
        this.parameters = parameters;
        this.run();
    }

    public WebArchive createArchive(SessionManagementTesterConfiguration configuration) {
        Object[] values = new Object[]{this.managerClass.getName(), this.parameters.getSessionPersistenceGranularity(), this.parameters.getSessionMarshallerFactory()};
        return (WebArchive)((WebArchive)((WebArchive)super.createArchive(configuration)).addAsResource("infinispan.xml")).addAsManifestResource((Asset)new StringAsset(String.format(CONTEXT_XML, values)), "context.xml");
    }

    public static class InfinispanSessionManagerArgumentsProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            Stream.Builder<Arguments> builder = Stream.builder();
            for (final SessionPersistenceGranularity strategy : EnumSet.allOf(SessionPersistenceGranularity.class)) {
                for (final SessionMarshallerFactory marshaller : EnumSet.allOf(SessionMarshallerFactory.class)) {
                    builder.add(Arguments.of((Object[])new Object[]{new SessionManagementParameters(){

                        @Override
                        public SessionPersistenceGranularity getSessionPersistenceGranularity() {
                            return strategy;
                        }

                        @Override
                        public SessionMarshallerFactory getSessionMarshallerFactory() {
                            return marshaller;
                        }

                        public String toString() {
                            return Map.of(SessionPersistenceGranularity.class.getSimpleName(), strategy, SessionMarshallerFactory.class.getSimpleName(), marshaller).toString();
                        }
                    }}));
                }
            }
            return builder.build();
        }
    }
}

