/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

class LessEqualFilterSpec
extends FilterSpec {
    private final String attribute;
    private final AttributeValue value;

    LessEqualFilterSpec(String attribute, AttributeValue value) {
        this.attribute = attribute;
        this.value = value;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        AttributeValue other = attributes.get(this.attribute);
        return this.value.compareTo(other) <= 0;
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        Collection<AttributeValue> collection = attributes.get(attributes);
        if (collection != null) {
            for (AttributeValue value : collection) {
                if (this.value.compareTo(value) > 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(');
        FilterSpec.escapeTo(this.attribute, builder);
        builder.append('<');
        builder.append('=');
        builder.append(this.value);
        builder.append(')');
    }
}

