/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

final class SubstringFilterSpec
extends FilterSpec {
    private final String attribute;
    private final String initialPart;
    private final String finalPart;

    public SubstringFilterSpec(String attribute, String initialPart, String finalPart) {
        this.attribute = attribute;
        this.initialPart = initialPart;
        this.finalPart = finalPart;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        String value = attributes.get(this.attribute).toString();
        return value.startsWith(this.initialPart) && value.endsWith(this.finalPart);
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        Collection<AttributeValue> collection = attributes.get(this.attribute);
        if (collection != null) {
            for (AttributeValue matchValue : collection) {
                String value = matchValue.toString();
                if (!value.startsWith(this.initialPart) || !value.endsWith(this.finalPart)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(');
        FilterSpec.escapeTo(this.attribute, builder);
        builder.append('=');
        FilterSpec.escapeTo(this.initialPart, builder);
        builder.append('*');
        FilterSpec.escapeTo(this.finalPart, builder);
        builder.append(')');
    }
}

