/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.transformer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.wildfly.galleon.plugin.transformer.EclipseTransformer;
import org.wildfly.galleon.plugin.transformer.TransformedArtifact;
import org.wildfly.galleon.plugin.transformer.Utils;

public class JakartaTransformer {
    public static final String TRANSFORM_ARTIFACTS = "jakarta.transform.artifacts";
    private static final LogHandler DEFAULT_LOG_HANDLER = new LogHandler(){

        @Override
        public void print(String format, Object ... args) {
            System.out.println(String.format(format, args));
        }
    };

    public static void main(String[] args) throws Exception {
        EclipseTransformer.transform(args, false);
    }

    public static InputStream transform(InputStream in, String name, boolean verbose, LogHandler log) throws IOException {
        int size;
        if (log == null) {
            log = DEFAULT_LOG_HANDLER;
        }
        if (!(name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".rar") || name.endsWith(".jar") || name.endsWith(".xml"))) {
            name = name + ".war";
        }
        Path dir = Files.createTempDirectory("jakarta-transform", new FileAttribute[0]);
        Path src = dir.resolve("jakartaee-" + name);
        Path target = dir.resolve(name);
        FileOutputStream out = new FileOutputStream(src.toFile());
        byte[] buffer = new byte[1024];
        while ((size = in.read(buffer)) != -1) {
            out.write(buffer, 0, size);
        }
        out.close();
        EclipseTransformer.transform(src, target, verbose, log);
        return new WrappedInputStream(target.toFile(), dir);
    }

    public static TransformedArtifact transform(Path src, Path target, boolean verbose, LogHandler log) throws IOException {
        if (log == null) {
            log = DEFAULT_LOG_HANDLER;
        }
        Path originalSrc = src;
        Path actualTarget = null;
        Path safeCopy = null;
        boolean failed = false;
        boolean isExploded = false;
        if (Files.isDirectory(src, new LinkOption[0])) {
            isExploded = true;
            if (target.equals(src)) {
                safeCopy = target.getParent().resolve("jakartaee-" + target.getFileName().toString());
                log.print("Transformation target is equal to src, moving src artifact directory to %s", safeCopy);
                Utils.copy(src, safeCopy);
                Utils.recursiveDelete(src);
                src = safeCopy;
            }
            actualTarget = target;
        } else if (Files.isDirectory(target, new LinkOption[0])) {
            actualTarget = target.resolve(src.getFileName());
        } else {
            if (src.equals(target)) {
                safeCopy = target.getParent().resolve("jakartaee-" + target.getFileName().toString());
                log.print("Transformation target is equal to src, moving src artifact to %s", safeCopy);
                if (Files.exists(safeCopy, new LinkOption[0])) {
                    Files.delete(safeCopy);
                }
                Files.copy(src, safeCopy, new CopyOption[0]);
                Files.delete(src);
                src = safeCopy;
            }
            actualTarget = target;
        }
        if (Files.exists(actualTarget, new LinkOption[0])) {
            throw new IOException("Transformation target " + actualTarget + " already exist");
        }
        try {
            TransformedArtifact transformedArtifact = EclipseTransformer.transform(src, actualTarget, verbose, log);
            return transformedArtifact;
        }
        catch (Throwable ex) {
            failed = true;
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
        finally {
            if (failed && safeCopy != null) {
                log.print("Exception occured, reverting original src artifact", new Object[0]);
                if (isExploded) {
                    Utils.copy(safeCopy, originalSrc);
                } else {
                    Files.copy(safeCopy, originalSrc, new CopyOption[0]);
                }
            }
            if (safeCopy != null) {
                if (isExploded) {
                    Utils.recursiveDelete(safeCopy);
                } else {
                    Files.delete(safeCopy);
                }
            }
        }
    }

    public static interface LogHandler {
        public void print(String var1, Object ... var2);
    }

    static class WrappedInputStream
    extends FileInputStream {
        private final Path dir;

        public WrappedInputStream(File file, Path dir) throws FileNotFoundException {
            super(file);
            this.dir = dir;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Utils.recursiveDelete(this.dir);
        }
    }
}

