/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class ResourceTransformer {
    private static final String DEFAULT_CONFIG = "default.mapping";
    private static final int MAX_MAPPINGS = 65535;
    private static final char DOT = '.';
    private static final char SEP = '/';
    protected final Map<String, String> mappingWithSeps = new HashMap<String, String>();
    protected final Map<String, String> mappingWithDots = new HashMap<String, String>();
    protected final boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceTransformer(File configsDir, boolean verbose) throws IOException {
        this.verbose = verbose;
        File userConfig = new File(configsDir, DEFAULT_CONFIG);
        InputStream mappingFile = userConfig.exists() && userConfig.isFile() ? new FileInputStream(userConfig) : ResourceTransformer.class.getResourceAsStream("/default.mapping");
        if (mappingFile == null) {
            throw new IllegalArgumentException("Couldn't find specified config file neither on file system nor on class path");
        }
        try {
            Properties packagesMapping = new Properties();
            packagesMapping.load(mappingFile);
            for (String from : packagesMapping.stringPropertyNames()) {
                String to = packagesMapping.getProperty(from);
                if (to.indexOf(46) != -1 || from.indexOf(46) != -1) {
                    throw new IllegalArgumentException("Packages mapping config file must be property file in path separator format only");
                }
                this.addMapping(from, to);
            }
            if (this.mappingWithSeps.size() == 0) {
                throw new IllegalStateException("No mapping was defined in packages mapping config file");
            }
        }
        finally {
            ResourceTransformer.safeClose(mappingFile);
        }
    }

    private static void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addMapping(String from, String to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Package definition cannot be null");
        }
        if (from.length() == 0 || to.length() == 0) {
            throw new IllegalArgumentException("Package definition cannot be empty string");
        }
        if (from.equals(to)) {
            throw new IllegalArgumentException("Identical package mapping detected: " + from + " -> " + to);
        }
        for (String key : this.mappingWithSeps.keySet()) {
            if (key.contains(from)) {
                throw new IllegalArgumentException("Package " + from + " is substring of package " + key);
            }
            if (!from.contains(key)) continue;
            throw new IllegalArgumentException("Package " + key + " is substring of package " + from);
        }
        if (this.mappingWithSeps.size() > 65535) {
            throw new IllegalStateException("Packages mapping count exceeded value 65535");
        }
        this.mappingWithSeps.put(from, to);
        this.mappingWithDots.put(from.replace('/', '.'), to.replace('/', '.'));
    }

    protected abstract Resource[] transform(Resource var1);

    public static final class Resource {
        private final String name;
        private final byte[] data;

        public Resource(String name, byte[] data) {
            if (name == null || data == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.data = data;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

