/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import nu.xom.ParsingException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.layout.FeaturePackDescription;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathFilter;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.FeaturePackXmlWriter;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.FeatureSpecGeneratorInvoker;
import org.wildfly.galleon.maven.MavenProjectArtifactVersions;
import org.wildfly.galleon.maven.ModuleIdentifier;
import org.wildfly.galleon.maven.ModuleParseResult;
import org.wildfly.galleon.maven.ModuleXmlParser;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.maven.build.tasks.ResourcesTask;
import org.wildfly.galleon.plugin.ArtifactCoords;

@Mojo(name="build-feature-pack", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class WfFeaturePackBuildMojo
extends AbstractMojo {
    private static Pattern windowsLineEndingPattern = Pattern.compile("(?<!\\r)\\n", 8);
    private static Pattern linuxLineEndingPattern = Pattern.compile("\\r\\n", 8);
    private static PathFilter windowsLineEndingsPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getFileName().toString().endsWith(".bat");
        }
    };
    private static PathFilter linuxLineEndingsPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getFileName().toString();
            return name.endsWith(".sh") || name.endsWith(".conf");
        }
    };
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Component
    protected RepositorySystem repoSystem;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(alias="config-file", defaultValue="wildfly-feature-pack-build.xml", property="wildfly.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="resources-dir", defaultValue="src/main/resources", property="wildfly.feature.pack.resourcesDir", required=true)
    private String resourcesDir;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.feature.pack.buildName")
    private String buildName;
    @Parameter(alias="release-name", defaultValue="${product.release.name}")
    private String releaseName;
    @Parameter(alias="task-properties-file", required=false)
    private File taskPropsFile;
    @Parameter(alias="task-properties", required=false)
    private Map<String, String> taskProps = Collections.emptyMap();
    @Parameter(alias="feature-pack-artifact-id", defaultValue="${project.artifactId}", required=false)
    private String fpArtifactId;
    @Parameter(alias="fork-embedded", required=false)
    protected boolean forkEmbedded;
    @Parameter(alias="wildfly-home", property="wfgp.wildflyHome", defaultValue="${project.build.directory}/wildfly", required=true)
    protected File wildflyHome;
    @Parameter(alias="module-templates", property="wfgp.moduleTemplatesDir", defaultValue="${project.build.directory}/module-templates", required=true)
    protected File moduleTemplatesDir;
    @Parameter(alias="feature-specs-output", defaultValue="${project.build.directory}/resources/features", required=true)
    protected File featureSpecsOutput;
    @Component
    private MavenProjectHelper projectHelper;
    private MavenProjectArtifactVersions artifactVersions;
    private WildFlyFeaturePackBuild buildConfig;
    private Map<String, FeaturePackDescription> fpDependencies = Collections.emptyMap();
    private Map<String, PackageSpec.Builder> extendedPackages = Collections.emptyMap();

    private static boolean isProvided(String module) {
        return module.startsWith("java.") || module.startsWith("jdk.") || module.equals("org.jboss.modules");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute();
    }

    protected WildFlyFeaturePackBuild getBuildConfig() throws MojoExecutionException {
        return this.buildConfig == null ? (this.buildConfig = Util.loadFeaturePackBuildConfig(this.configDir, this.configFile)) : this.buildConfig;
    }

    private void doExecute() throws MojoExecutionException, MojoFailureException {
        Path scriptsDir;
        FeaturePackLocation fpl;
        String channel;
        this.artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
        Path targetResources = Paths.get(this.buildName, "resources");
        Path specsDir = this.configDir.getAbsoluteFile().toPath().resolve(this.resourcesDir);
        if (Files.exists(specsDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)specsDir, (Path)targetResources);
            }
            catch (IOException e1) {
                throw new MojoExecutionException(Errors.copyFile((Path)specsDir, (Path)targetResources), (Exception)e1);
            }
        }
        Path workDir = Paths.get(this.buildName, "layout");
        IoUtils.recursiveDelete((Path)workDir);
        Path fpDir = workDir.resolve(this.project.getGroupId()).resolve(this.fpArtifactId).resolve(this.project.getVersion());
        Path fpPackagesDir = fpDir.resolve("packages");
        this.buildConfig = this.getBuildConfig();
        if (this.buildConfig.hasStandaloneExtensions() || this.buildConfig.hasDomainExtensions() || this.buildConfig.hasHostExtensions()) {
            new FeatureSpecGeneratorInvoker(this).execute();
        }
        if ((channel = (fpl = this.buildConfig.getProducer()).getChannelName()) == null || channel.isEmpty()) {
            String v = this.project.getVersion();
            int i = v.indexOf(46);
            channel = i < 0 ? v : v.substring(0, i);
        }
        fpl = new FeaturePackLocation(fpl.getUniverse(), fpl.getProducerName(), channel, null, this.project.getVersion());
        FeaturePackDescription.Builder fpBuilder = FeaturePackDescription.builder((FeaturePackSpec.Builder)FeaturePackSpec.builder((FeaturePackLocation.FPID)fpl.getFPID()));
        for (String defaultPackage : this.buildConfig.getDefaultPackages()) {
            fpBuilder.getSpecBuilder().addDefaultPackage(defaultPackage);
        }
        try {
            this.processFeaturePackDependencies(fpBuilder.getSpecBuilder());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to process dependencies", e);
        }
        Path srcModulesDir = targetResources.resolve("modules");
        if (Files.exists(srcModulesDir, new LinkOption[0])) {
            this.addModulePackages(srcModulesDir, fpBuilder, targetResources, fpPackagesDir);
        } else {
            this.getLog().warn((CharSequence)("No modules found at " + srcModulesDir));
        }
        Path contentDir = targetResources.resolve("content");
        if (Files.exists(contentDir, new LinkOption[0])) {
            try {
                this.packageContent(fpBuilder, contentDir, fpPackagesDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process content", (Exception)e);
            }
        }
        if (this.buildConfig.hasSchemaGroups()) {
            this.addDocsSchemas(fpPackagesDir, fpBuilder);
        }
        this.addConfigPackages(targetResources.resolve("packages"), fpDir.resolve("packages"), fpBuilder);
        PackageSpec.Builder docsBuilder = this.getExtendedPackage("docs", false);
        if (docsBuilder != null) {
            fpBuilder.getSpecBuilder().addDefaultPackage(this.addPackage(fpPackagesDir, fpBuilder, docsBuilder).getName());
        }
        if (!this.fpDependencies.isEmpty() && !this.extendedPackages.isEmpty()) {
            for (Map.Entry<String, PackageSpec.Builder> entry2 : this.fpDependencies.entrySet()) {
                FeaturePackDescription fpDepLayout = (FeaturePackDescription)entry2.getValue();
                for (Map.Entry<String, PackageSpec.Builder> entry3 : this.extendedPackages.entrySet()) {
                    if (!fpDepLayout.hasPackage(entry3.getKey())) continue;
                    entry3.getValue().addPackageDep(entry2.getKey(), entry3.getKey());
                }
            }
        }
        for (Map.Entry<String, PackageSpec.Builder> entry4 : this.extendedPackages.entrySet()) {
            this.addPackage(fpPackagesDir, fpBuilder, entry4.getValue());
        }
        this.copyIfExists(targetResources, fpDir, "layers");
        this.copyIfExists(targetResources, fpDir, "configs");
        if (this.buildConfig.hasConfigs()) {
            for (ConfigModel configModel : this.buildConfig.getConfigs()) {
                try {
                    fpBuilder.getSpecBuilder().addConfig(configModel);
                }
                catch (ProvisioningDescriptionException e) {
                    throw new MojoExecutionException("Failed to add config to the feature-pack", (Exception)((Object)e));
                }
            }
        }
        try {
            FeaturePackDescription fpLayout = fpBuilder.build();
            FeaturePackXmlWriter.getInstance().write((Object)fpLayout.getSpec(), fpDir.resolve("feature-pack.xml"));
        }
        catch (IOException | XMLStreamException | ProvisioningDescriptionException throwable) {
            throw new MojoExecutionException(Errors.writeFile((Path)fpDir.resolve("feature-pack.xml")), (Exception)throwable);
        }
        this.copyDirIfExists(targetResources.resolve("features"), fpDir.resolve("features"));
        this.copyDirIfExists(targetResources.resolve("feature_groups"), fpDir.resolve("feature_groups"));
        Path path = fpDir.resolve("resources");
        Path resourcesWildFly = path.resolve("wildfly");
        WfFeaturePackBuildMojo.mkdirs(resourcesWildFly);
        if (this.buildConfig.hasPlugins()) {
            this.addPlugins(fpDir, this.buildConfig.getPlugins());
        }
        if (this.buildConfig.hasResourcesTasks()) {
            for (ResourcesTask resourcesTask : this.buildConfig.getResourcesTasks()) {
                resourcesTask.execute(this, path);
            }
        }
        try {
            Throwable throwable = null;
            try (OutputStream out = Files.newOutputStream(resourcesWildFly.resolve("wildfly-tasks.properties"), new OpenOption[0]);){
                this.getFPConfigProperties().store(out, "WildFly feature-pack properties");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store feature-pack properties", (Exception)e);
        }
        for (ArtifactCoords.Gav gav : this.buildConfig.getDependencies().keySet()) {
            this.artifactVersions.remove(gav.getGroupId(), gav.getArtifactId());
        }
        try {
            this.artifactVersions.store(resourcesWildFly.resolve("artifact-versions.properties"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store artifact versions", (Exception)e);
        }
        if (this.buildConfig.hasStandaloneExtensions()) {
            this.persistExtensions(resourcesWildFly, "extensions-standalone", this.buildConfig.getStandaloneExtensions());
        }
        if (this.buildConfig.hasDomainExtensions()) {
            this.persistExtensions(resourcesWildFly, "extensions-domain", this.buildConfig.getDomainExtensions());
        }
        if (this.buildConfig.hasHostExtensions()) {
            this.persistExtensions(resourcesWildFly, "extensions-host", this.buildConfig.getHostExtensions());
        }
        if (Files.exists(scriptsDir = targetResources.resolve("scripts"), new LinkOption[0])) {
            if (!Files.isDirectory(scriptsDir, new LinkOption[0])) {
                throw new MojoExecutionException("scripts is not a directory");
            }
            try {
                IoUtils.copy((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts"));
            }
            catch (IOException iOException) {
                throw new MojoExecutionException(Errors.copyFile((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts")), (Exception)iOException);
            }
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(workDir, entry -> Files.isDirectory(entry, new LinkOption[0]));){
            for (Path groupDir : directoryStream) {
                DirectoryStream<Path> groupStream = Files.newDirectoryStream(groupDir);
                Throwable throwable = null;
                try {
                    for (Path artifactDir : groupStream) {
                        String artifactId = artifactDir.getFileName().toString();
                        DirectoryStream<Path> artifactStream = Files.newDirectoryStream(artifactDir);
                        Throwable throwable4 = null;
                        try {
                            for (Path versionDir : artifactStream) {
                                Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(artifactId + '-' + versionDir.getFileName() + ".zip");
                                if (Files.exists(target, new LinkOption[0])) {
                                    IoUtils.recursiveDelete((Path)target);
                                }
                                ZipUtils.zip((Path)versionDir, (Path)target);
                                this.debug("Attaching feature-pack %s as a project artifact", target);
                                this.projectHelper.attachArtifact(this.project, "zip", target.toFile());
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (artifactStream == null) continue;
                            if (throwable4 != null) {
                                try {
                                    artifactStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            artifactStream.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (groupStream == null) continue;
                    if (throwable != null) {
                        try {
                            groupStream.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    groupStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to create a feature-pack archives from the layout", (Exception)iOException);
        }
    }

    private void copyIfExists(Path resources, Path fpDir, String resourceName) throws MojoExecutionException {
        Path res = resources.resolve(resourceName);
        if (Files.exists(res, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)res, (Path)fpDir.resolve(resourceName));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy " + resourceName + " to the feature-pack", (Exception)e);
            }
        }
    }

    private void persistExtensions(Path resourcesWildFly, String name, List<String> extensions) throws MojoExecutionException {
        try {
            Files.write(resourcesWildFly.resolve(name), extensions, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist " + name, (Exception)e);
        }
    }

    private PackageSpec addPackage(Path fpPackagesDir, FeaturePackDescription.Builder fpBuilder, PackageSpec.Builder pkgBuilder) throws MojoExecutionException {
        PackageSpec pkg = pkgBuilder.build();
        fpBuilder.addPackage(pkg);
        this.writeXml(pkg, fpPackagesDir.resolve(pkg.getName()));
        return pkg;
    }

    private PackageSpec.Builder getExtendedPackage(String name, boolean create) {
        PackageSpec.Builder pkgBuilder = this.extendedPackages.get(name);
        if (pkgBuilder == null) {
            if (!create) {
                return null;
            }
            pkgBuilder = PackageSpec.builder((String)name);
            this.extendedPackages = CollectionUtils.put(this.extendedPackages, (Object)name, (Object)pkgBuilder);
        }
        return pkgBuilder;
    }

    private void addModulePackages(Path srcModulesDir, FeaturePackDescription.Builder fpBuilder, Path targetResources, Path fpPackagesDir) throws MojoExecutionException {
        Path layersConf;
        this.debug("WfFeaturePackBuildMojo adding module packages", new Object[0]);
        Path layersDir = srcModulesDir.resolve("system").resolve("layers");
        if (Files.exists(layersDir, new LinkOption[0])) {
            PackageSpec.Builder modulesAll = this.getExtendedPackage("modules.all", true);
            try (Stream<Path> layers = Files.list(layersDir);){
                HashMap<String, Path> moduleXmlByPkgName = new HashMap<String, Path>();
                Iterator i = layers.iterator();
                while (i.hasNext()) {
                    Path layerDir = (Path)i.next();
                    this.findModules(layerDir, moduleXmlByPkgName);
                    if (!moduleXmlByPkgName.isEmpty()) continue;
                    throw new MojoExecutionException("Modules not found in " + layerDir);
                }
                this.packageModules(fpBuilder, targetResources, moduleXmlByPkgName, fpPackagesDir, modulesAll);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process modules content", (Exception)e);
            }
        }
        if (!Files.exists(layersConf = srcModulesDir.resolve("layers.conf"), new LinkOption[0])) {
            return;
        }
        Path targetPath = fpPackagesDir.resolve("layers.conf").resolve("content").resolve("modules").resolve("layers.conf");
        try {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            IoUtils.copy((Path)layersConf, (Path)targetPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.copyFile((Path)layersConf, (Path)targetPath), (Exception)e);
        }
        PackageSpec.Builder pkgBuilder = PackageSpec.builder((String)"layers.conf");
        this.addPackage(fpPackagesDir, fpBuilder, pkgBuilder);
        fpBuilder.getSpecBuilder().addDefaultPackage("layers.conf");
    }

    private void copyDirIfExists(Path srcDir, Path targetDir) throws MojoExecutionException {
        if (Files.exists(srcDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)srcDir, (Path)targetDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)srcDir, (Path)targetDir), (Exception)e);
            }
        }
    }

    private void addPlugins(Path fpDir, List<String> artifacts) throws MojoExecutionException {
        Path pluginsDir = fpDir.resolve("plugins");
        WfFeaturePackBuildMojo.mkdirs(pluginsDir);
        for (String artifact : artifacts) {
            Path wfPlugInPath;
            ArtifactCoords coords = ArtifactCoordsUtil.fromJBossModules(artifact, "jar");
            if (coords.getVersion() == null) {
                coords = ArtifactCoordsUtil.fromJBossModules(this.resolveVersion(artifact), "jar");
            }
            try {
                wfPlugInPath = this.resolveArtifact(ArtifactCoords.newInstance((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getVersion(), (String)coords.getExtension()));
            }
            catch (ProvisioningException e) {
                throw new MojoExecutionException("Failed to build feature-pack", (Exception)((Object)e));
            }
            try {
                IoUtils.copy((Path)wfPlugInPath, (Path)pluginsDir.resolve(coords.getArtifactId() + '.' + coords.getExtension()));
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)wfPlugInPath, (Path)pluginsDir.resolve(coords.getArtifactId() + '.' + coords.getExtension())));
            }
        }
    }

    public String resolveVersion(String coordsWoVersion) throws MojoExecutionException {
        String resolved = this.artifactVersions.getVersion(coordsWoVersion);
        if (resolved == null) {
            throw new MojoExecutionException("The project is missing dependency on " + coordsWoVersion);
        }
        return resolved;
    }

    private static void mkdirs(Path dir) throws MojoExecutionException {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)dir), (Exception)e);
        }
    }

    private void addDocsSchemas(Path fpPackagesDir, FeaturePackDescription.Builder fpBuilder) throws MojoExecutionException {
        this.getExtendedPackage("docs.schema", true);
        this.getExtendedPackage("docs", true).addPackageDep("docs.schema", true);
        Path schemasPackageDir = fpPackagesDir.resolve("docs.schema");
        Path schemaGroupsTxt = schemasPackageDir.resolve("pm").resolve("wildfly").resolve("schema-groups.txt");
        BufferedWriter writer = null;
        try {
            WfFeaturePackBuildMojo.mkdirs(schemasPackageDir);
            WfFeaturePackBuildMojo.mkdirs(schemaGroupsTxt.getParent());
            writer = Files.newBufferedWriter(schemaGroupsTxt, new OpenOption[0]);
            for (String group : this.buildConfig.getSchemaGroups()) {
                writer.write(group);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)schemaGroupsTxt.getParent()), (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addConfigPackages(Path configDir, Path packagesDir, FeaturePackDescription.Builder fpBuilder) throws MojoExecutionException {
        if (!Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configDir);){
            for (Path configPackage : stream) {
                PackageSpec pkgSpec;
                Path packageDir = packagesDir.resolve(configPackage.getFileName());
                if (!Files.exists(packageDir, new LinkOption[0])) {
                    WfFeaturePackBuildMojo.mkdirs(packageDir);
                }
                IoUtils.copy((Path)configPackage, (Path)packageDir);
                Path packageXml = configPackage.resolve("package.xml");
                if (!Files.exists(packageXml, new LinkOption[0])) continue;
                try (BufferedReader reader = Files.newBufferedReader(packageXml);){
                    try {
                        pkgSpec = PackageXmlParser.getInstance().parse((Reader)reader);
                    }
                    catch (XMLStreamException e) {
                        throw new MojoExecutionException("Failed to parse " + packageXml, (Exception)e);
                    }
                }
                IoUtils.copy((Path)packageXml, (Path)packageDir.resolve("package.xml"));
                fpBuilder.addPackage(pkgSpec);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process config packages", (Exception)e);
        }
    }

    private void processFeaturePackDependencies(FeaturePackSpec.Builder fpBuilder) throws Exception {
        if (this.buildConfig.getDependencies().isEmpty()) {
            return;
        }
        this.fpDependencies = new LinkedHashMap<String, FeaturePackDescription>(this.buildConfig.getDependencies().size());
        for (Map.Entry<ArtifactCoords.Gav, FeaturePackDependencySpec> depEntry : this.buildConfig.getDependencies().entrySet()) {
            ArtifactCoords depCoords = depEntry.getKey().toArtifactCoords();
            if (depCoords.getVersion() == null) {
                String coordsStr = this.artifactVersions.getVersion(depCoords.getGroupId() + ':' + depCoords.getArtifactId());
                if (coordsStr == null) {
                    throw new MojoExecutionException("Failed resolve artifact version for " + depCoords);
                }
                depCoords = ArtifactCoordsUtil.fromJBossModules(coordsStr, "zip");
                if (depCoords.getExtension().equals("pom")) {
                    depCoords = new ArtifactCoords(depCoords.getGroupId(), depCoords.getArtifactId(), depCoords.getVersion(), depCoords.getClassifier(), "zip");
                }
            }
            Path depZip = this.resolveArtifact(depCoords);
            FeaturePackLocation depFpl = FeaturePackDescriber.readSpec((Path)depZip).getFPID().getLocation();
            FeaturePackDependencySpec depSpec = depEntry.getValue();
            FeaturePackConfig depConfig = depSpec.getTarget();
            fpBuilder.addFeaturePackDep(depSpec.getName(), FeaturePackConfig.builder((FeaturePackLocation)depFpl).init(depConfig).build());
            this.fpDependencies.put(depSpec.getName(), FeaturePackDescriber.describeFeaturePackZip((Path)depZip));
        }
    }

    private void packageContent(FeaturePackDescription.Builder fpBuilder, Path contentDir, Path packagesDir) throws IOException, MojoExecutionException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(contentDir);){
            for (Path p : stream) {
                String pkgName = p.getFileName().toString();
                Path pkgDir = packagesDir.resolve(pkgName);
                Path pkgContentDir = pkgDir.resolve("content").resolve(pkgName);
                PackageSpec.Builder pkgBuilder = this.getExtendedPackage(pkgName, true);
                if (pkgName.equals("docs")) {
                    try (DirectoryStream<Path> docsStream = Files.newDirectoryStream(p);){
                        for (Path docPath : docsStream) {
                            String docName = docPath.getFileName().toString();
                            String docPkgName = "docs." + docName;
                            Path docDir = packagesDir.resolve(docPkgName);
                            this.getExtendedPackage(docPkgName, true);
                            Path docContentDir = docDir.resolve("content").resolve("docs").resolve(docName);
                            IoUtils.copy((Path)docPath, (Path)docContentDir);
                            pkgBuilder.addPackageDep(docPkgName, true);
                            WfFeaturePackBuildMojo.ensureLineEndings(docContentDir);
                        }
                    }
                }
                if (pkgName.equals("bin")) {
                    Path binStandalonePkgDir = packagesDir.resolve("bin.standalone").resolve("content").resolve(pkgName);
                    Path binDomainPkgDir = packagesDir.resolve("bin.domain").resolve("content").resolve(pkgName);
                    try (DirectoryStream<Path> binStream = Files.newDirectoryStream(p);){
                        for (Path binPath : binStream) {
                            String fileName = binPath.getFileName().toString();
                            if (fileName.startsWith("standalone")) {
                                IoUtils.copy((Path)binPath, (Path)binStandalonePkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("domain")) {
                                IoUtils.copy((Path)binPath, (Path)binDomainPkgDir.resolve(fileName));
                                continue;
                            }
                            IoUtils.copy((Path)binPath, (Path)pkgContentDir.resolve(fileName));
                        }
                    }
                    if (Files.exists(binStandalonePkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binStandalonePkgDir);
                        this.getExtendedPackage("bin.standalone", true).addPackageDep(pkgName);
                    }
                    if (Files.exists(binDomainPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binDomainPkgDir);
                        this.getExtendedPackage("bin.domain", true).addPackageDep(pkgName);
                    }
                } else {
                    IoUtils.copy((Path)p, (Path)pkgContentDir);
                }
                if (!Files.exists(pkgContentDir, new LinkOption[0])) continue;
                WfFeaturePackBuildMojo.ensureLineEndings(pkgContentDir);
            }
        }
    }

    private void findModules(final Path modulesDir, final Map<String, Path> moduleXmlByPkgName) throws IOException {
        Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path moduleXml = dir.resolve("module.xml");
                if (!Files.exists(moduleXml, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                String packageName = moduleXml.getParent().getFileName().toString().equals("main") ? modulesDir.relativize(moduleXml.getParent().getParent()).toString() : modulesDir.relativize(moduleXml.getParent()).toString();
                packageName = packageName.replace(File.separatorChar, '.');
                moduleXmlByPkgName.put(packageName, moduleXml);
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void packageModules(FeaturePackDescription.Builder fpBuilder, Path resourcesDir, Map<String, Path> moduleXmlByPkgName, Path packagesDir, PackageSpec.Builder modulesAll) throws IOException, MojoExecutionException {
        for (Map.Entry<String, Path> module : moduleXmlByPkgName.entrySet()) {
            String packageName = module.getKey();
            Path moduleXml = module.getValue();
            Path packageDir = packagesDir.resolve(packageName);
            Path targetXml = packageDir.resolve("pm").resolve("wildfly").resolve("module").resolve(resourcesDir.relativize(moduleXml));
            WfFeaturePackBuildMojo.mkdirs(targetXml.getParent());
            IoUtils.copy((Path)moduleXml.getParent(), (Path)targetXml.getParent());
            PackageSpec.Builder pkgSpecBuilder = PackageSpec.builder((String)packageName);
            try {
                ModuleParseResult parsedModule = ModuleXmlParser.parse(targetXml, "UTF-8");
                if (!parsedModule.dependencies.isEmpty()) {
                    for (ModuleParseResult.ModuleDependency moduleDep : parsedModule.dependencies) {
                        ModuleIdentifier moduleId = moduleDep.getModuleId();
                        String depName = moduleId.getName();
                        if (!moduleId.getSlot().equals("main")) {
                            depName = depName + '.' + moduleId.getSlot();
                        }
                        if (moduleXmlByPkgName.containsKey(depName)) {
                            pkgSpecBuilder.addPackageDep(this.getPackageDepSpec(packageName, moduleXml, moduleDep, depName));
                            continue;
                        }
                        Map.Entry<String, FeaturePackDescription> depSrc = null;
                        if (!this.fpDependencies.isEmpty()) {
                            Set alternativeSrc = Collections.emptySet();
                            for (Map.Entry<String, FeaturePackDescription> depEntry : this.fpDependencies.entrySet()) {
                                if (!depEntry.getValue().hasPackage(depName)) continue;
                                if (depSrc != null) {
                                    alternativeSrc = CollectionUtils.add(alternativeSrc, (Object)depSrc.getKey());
                                }
                                depSrc = depEntry;
                            }
                            if (!alternativeSrc.isEmpty()) {
                                StringBuilder warn = new StringBuilder();
                                warn.append("Package ").append(depName).append(" from ").append(depSrc.getKey()).append(" picked as dependency of ").append(packageName).append(" although ").append(depName).append(" also exists in ");
                                StringUtils.append((StringBuilder)warn, (Iterable)alternativeSrc);
                                this.getLog().warn((CharSequence)warn);
                            }
                        }
                        if (depSrc != null) {
                            pkgSpecBuilder.addPackageDep((String)depSrc.getKey(), this.getPackageDepSpec(packageName, moduleXml, moduleDep, depName));
                            continue;
                        }
                        if (moduleDep.isOptional() || WfFeaturePackBuildMojo.isProvided(depName)) continue;
                        throw new MojoExecutionException("Package " + packageName + " has unsatisifed external dependency on package " + depName);
                    }
                }
            }
            catch (ParsingException e) {
                throw new IOException(Errors.parseXml((Path)targetXml), e);
            }
            PackageSpec pkgSpec = pkgSpecBuilder.build();
            try {
                PackageXmlWriter.getInstance().write((Object)pkgSpec, packageDir.resolve("package.xml"));
            }
            catch (XMLStreamException e) {
                throw new IOException(Errors.writeFile((Path)packageDir.resolve("package.xml")), e);
            }
            modulesAll.addPackageDep(packageName, true);
            fpBuilder.addPackage(pkgSpec);
        }
    }

    private PackageDependencySpec getPackageDepSpec(String packageName, Path moduleXml, ModuleParseResult.ModuleDependency moduleDep, String depName) throws ParsingException {
        PackageDependencySpec depSpec;
        String passiveValue = moduleDep.getProperty("galleon.passive");
        if (passiveValue != null && Boolean.parseBoolean(passiveValue)) {
            if (!moduleDep.isOptional()) {
                throw new ParsingException("Required dependency on module " + packageName + " cannot be annotated as galleon.passive in " + moduleXml);
            }
            depSpec = PackageDependencySpec.passive((String)depName);
        } else {
            depSpec = moduleDep.isOptional() ? PackageDependencySpec.optional((String)depName) : PackageDependencySpec.required((String)depName);
        }
        return depSpec;
    }

    private Properties getFPConfigProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        properties.put("project.version", this.project.getVersion());
        properties.put("version", this.project.getVersion());
        if (this.releaseName != null) {
            properties.put("product.release.name", this.releaseName);
        }
        if (this.taskPropsFile != null) {
            Path p = this.taskPropsFile.toPath();
            if (!Files.exists(p, new LinkOption[0])) {
                throw new MojoExecutionException(Errors.pathDoesNotExist((Path)p));
            }
            try (BufferedReader reader = Files.newBufferedReader(p);){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.readFile((Path)p), (Exception)e);
            }
        }
        if (!this.taskProps.isEmpty()) {
            properties.putAll(this.taskProps);
        }
        return properties;
    }

    private void writeXml(PackageSpec pkgSpec, Path dir) throws MojoExecutionException {
        try {
            WfFeaturePackBuildMojo.mkdirs(dir);
            PackageXmlWriter.getInstance().write((Object)pkgSpec, dir.resolve("package.xml"));
        }
        catch (IOException | XMLStreamException e) {
            throw new MojoExecutionException(Errors.writeFile((Path)dir.resolve("package.xml")), e);
        }
    }

    public Path resolveArtifact(ArtifactCoords coords) throws ProvisioningException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setLocalRepository(this.session.getLocalRepository());
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        try {
            ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getVersion(), "provided", coords.getExtension(), coords.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(coords.getExtension())));
            return result.getArtifact().getFile().toPath();
        }
        catch (ArtifactResolverException e) {
            throw new ProvisioningException(FpMavenErrors.artifactResolution((String)coords.toString()), (Throwable)e);
        }
    }

    private static void ensureLineEndings(Path file) throws MojoExecutionException {
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (linuxLineEndingsPathFilter.accept(file)) {
                        WfFeaturePackBuildMojo.ensureLineEndings(file, linuxLineEndingPattern, "\n");
                    } else if (windowsLineEndingsPathFilter.accept(file)) {
                        WfFeaturePackBuildMojo.ensureLineEndings(file, windowsLineEndingPattern, "\r\n");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to adjust line endings for " + file, (Exception)e);
        }
    }

    private static void ensureLineEndings(Path file, Pattern pattern, String lineEnding) throws IOException {
        Matcher matcher;
        String fixedContent;
        String content = IoUtils.readFile((Path)file);
        if (content.equals(fixedContent = (matcher = pattern.matcher(content)).replaceAll(lineEnding))) {
            return;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(fixedContent.getBytes("UTF-8"));){
            Files.copy(in, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }
}

