/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.galleon.maven.FeatureSpecExporter;

public class EmbeddedScriptRunner {
    public static void exportStandalone(Path wildfly, Path outputDir, Map<String, String> inheritedFeatures, Properties props) throws IOException, ProvisioningException {
        StandaloneServer server = EmbeddedProcessFactory.createStandaloneServer((String)wildfly.toAbsolutePath().toString(), null, null, (String[])new String[]{"--admin-only"});
        try {
            server.start();
            try (ModelControllerClient client = server.getModelControllerClient();){
                EmbeddedScriptRunner.exportFeatures(client, outputDir, inheritedFeatures);
            }
            catch (XMLStreamException | ProvisioningDescriptionException ex) {
                throw new ProvisioningException(ex.getMessage(), ex);
            }
        }
        catch (EmbeddedProcessStartException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        finally {
            server.stop();
            EmbeddedScriptRunner.clearXMLConfiguration(props);
        }
    }

    public static void exportDomain(Path wildfly, Path outputDir, Map<String, String> inheritedFeatures, Properties props) throws IOException, ProvisioningException {
        HostController host = EmbeddedProcessFactory.createHostController((String)wildfly.toAbsolutePath().toString(), null, null, (String[])new String[]{"--admin-only"});
        try {
            host.start();
            try (ModelControllerClient client = host.getModelControllerClient();){
                EmbeddedScriptRunner.exportFeatures(client, outputDir, inheritedFeatures);
            }
            catch (XMLStreamException | ProvisioningDescriptionException ex) {
                throw new ProvisioningException(ex.getMessage(), ex);
            }
        }
        catch (EmbeddedProcessStartException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        finally {
            host.stop();
            EmbeddedScriptRunner.clearXMLConfiguration(props);
        }
    }

    private static void exportFeatures(ModelControllerClient client, Path outputDir, Map<String, String> inheritedFeatures) throws IOException, ProvisioningDescriptionException, XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        ModelNode op = Operations.createOperation((String)"read-feature", (ModelNode)address);
        op.get("recursive").set(true);
        ModelNode result = client.execute(op);
        FeatureSpecExporter.export(result, outputDir, inheritedFeatures);
    }

    /*
     * Exception decompiling
     */
    public static ModelNode readStandaloneFeatures(Path wildfly, Properties props) throws IOException, ProvisioningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static ModelNode readDomainFeatures(Path wildfly, Properties props) throws IOException, ProvisioningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ModelNode readFeatures(ModelControllerClient client) throws IOException, ProvisioningDescriptionException, XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        ModelNode op = Operations.createOperation((String)"read-feature", (ModelNode)address);
        op.get("recursive").set(true);
        ModelNode result = client.execute(op);
        EmbeddedScriptRunner.checkOutcome(result);
        if (result.hasDefined("result")) {
            return result.require("result");
        }
        return result;
    }

    private static void checkOutcome(ModelNode result) throws ProvisioningDescriptionException {
        if (!result.get("outcome").asString().equals("success")) {
            if (result.hasDefined("failure-description")) {
                throw new ProvisioningDescriptionException(result.get("failure-description").asString());
            }
            throw new ProvisioningDescriptionException("Error executing operation " + result.asString());
        }
    }

    private static void clearXMLConfiguration(Properties props) {
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.parsers.DocumentBuilderFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.parsers.SAXParserFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.transform.TransformerFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.xpath.XPathFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.stream.XMLEventFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.stream.XMLInputFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.stream.XMLOutputFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.datatype.DatatypeFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.validation.SchemaFactory");
        EmbeddedScriptRunner.clearProperty(props, "org.xml.sax.driver");
    }

    private static void clearProperty(Properties props, String name) {
        if (props.containsKey(name)) {
            System.setProperty(name, props.getProperty(name));
        } else {
            System.clearProperty(name);
        }
    }
}

