/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;

public class WildFlyFeaturePackBuild {
    private final List<FeaturePackDependencySpec> dependencies;
    private final Set<String> schemaGroups;
    private final Set<String> defaultPackages;
    private final List<ConfigModel> configs;

    public static Builder builder() {
        return new Builder();
    }

    private WildFlyFeaturePackBuild(Builder builder) {
        this.dependencies = CollectionUtils.unmodifiable((List)builder.dependencies);
        this.schemaGroups = CollectionUtils.unmodifiable((Set)builder.schemaGroups);
        this.defaultPackages = CollectionUtils.unmodifiable((Set)builder.defaultPackages);
        this.configs = CollectionUtils.unmodifiable((List)builder.configs);
    }

    public Collection<String> getDefaultPackages() {
        return this.defaultPackages;
    }

    public List<FeaturePackDependencySpec> getDependencies() {
        return this.dependencies;
    }

    public boolean hasSchemaGroups() {
        return !this.schemaGroups.isEmpty();
    }

    public boolean isSchemaGroup(String groupId) {
        return this.schemaGroups.contains(groupId);
    }

    public Set<String> getSchemaGroups() {
        return this.schemaGroups;
    }

    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    public List<ConfigModel> getConfigs() {
        return this.configs;
    }

    public static class Builder {
        private List<FeaturePackDependencySpec> dependencies = Collections.emptyList();
        private Set<String> schemaGroups = Collections.emptySet();
        private Set<String> defaultPackages = Collections.emptySet();
        private List<ConfigModel> configs = Collections.emptyList();

        private Builder() {
        }

        public Builder addDefaultPackage(String packageName) {
            this.defaultPackages = CollectionUtils.add(this.defaultPackages, (Object)packageName);
            return this;
        }

        public Builder addDependency(FeaturePackDependencySpec dependency) {
            this.dependencies = CollectionUtils.add(this.dependencies, (Object)dependency);
            return this;
        }

        public Builder addSchemaGroup(String groupId) {
            this.schemaGroups = CollectionUtils.add(this.schemaGroups, (Object)groupId);
            return this;
        }

        public Builder addConfig(ConfigModel config) {
            this.configs = CollectionUtils.add(this.configs, (Object)config);
            return this;
        }

        public WildFlyFeaturePackBuild build() {
            return new WildFlyFeaturePackBuild(this);
        }

        void providesCapability(CapabilitySpec cap) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

