/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.FileFilterModelParser20;

public class CopyArtifactsModelParser20 {
    public static final String ELEMENT_LOCAL_NAME = "copy-artifacts";
    private final FileFilterModelParser20 fileFilterModelParser;

    public CopyArtifactsModelParser20() {
        this(new FileFilterModelParser20());
    }

    public CopyArtifactsModelParser20(FileFilterModelParser20 fileFilterModelParser) {
        this.fileFilterModelParser = fileFilterModelParser;
    }

    public List<CopyArtifact> parseCopyArtifacts(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<CopyArtifact> list = new ArrayList<CopyArtifact>();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return list;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACT: {
                            CopyArtifact.Builder cpBuilder = CopyArtifact.builder();
                            this.parseCopyArtifact(reader, cpBuilder);
                            list.add(cpBuilder.build());
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseCopyArtifact(XMLStreamReader reader, CopyArtifact.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ARTIFACT: {
                    builder.setArtifact(reader.getAttributeValue(i));
                    continue block12;
                }
                case TO_LOCATION: {
                    builder.setToLocation(reader.getAttributeValue(i));
                    continue block12;
                }
                case EXTRACT: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block12;
                    builder.setExtract();
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            FileFilter.Builder filterBuilder = FileFilter.builder();
                            this.fileFilterModelParser.parseFilter(reader, filterBuilder);
                            builder.addFilter(filterBuilder.build());
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        UNKNOWN(null),
        ARTIFACT("artifact"),
        TO_LOCATION("to-location"),
        EXTRACT("extract");

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>();
            attributesMap.put(ARTIFACT.getLocalName(), ARTIFACT);
            attributesMap.put(TO_LOCATION.getLocalName(), TO_LOCATION);
            attributesMap.put(EXTRACT.getLocalName(), EXTRACT);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        COPY_ARTIFACT("copy-artifact"),
        FILTER("filter");

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Element> elementsMap = new HashMap<String, Element>();
            elementsMap.put(COPY_ARTIFACT.getLocalName(), COPY_ARTIFACT);
            elementsMap.put(FILTER.getLocalName(), FILTER);
            elements = elementsMap;
        }
    }
}

