/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;
import org.wildfly.galleon.plugin.config.CopyPath;

public class CopyPathsModelParser20 {
    public static final String ELEMENT_LOCAL_NAME = "copy-paths";

    public List<CopyPath> parseCopyPaths(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<CopyPath> list = new ArrayList<CopyPath>();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return list;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PATH: {
                            this.parseCopyPath(reader, list);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseCopyPath(XMLStreamReader reader, List<CopyPath> list) throws XMLStreamException {
        CopyPath.Builder builder = CopyPath.builder();
        boolean src = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case SRC: {
                    builder.setSrc(reader.getAttributeValue(i));
                    src = true;
                    continue block5;
                }
                case TARGET: {
                    builder.setTarget(reader.getAttributeValue(i));
                    continue block5;
                }
                case REPLACE_PROPERTIES: {
                    builder.setReplaceProperties(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!src) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.SRC));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        list.add(builder.build());
    }

    static enum Attribute implements XmlNameProvider
    {
        SRC("src"),
        TARGET("target"),
        REPLACE_PROPERTIES("replace-props"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>();
            attributesMap.put(SRC.getLocalName(), SRC);
            attributesMap.put(TARGET.getLocalName(), TARGET);
            attributesMap.put(REPLACE_PROPERTIES.getLocalName(), REPLACE_PROPERTIES);
            attributes = attributesMap;
        }
    }

    static enum Element {
        PATH("path"),
        UNKNOWN(null);

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            elements = Collections.singletonMap(PATH.getLocalName(), PATH);
        }
    }
}

