/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;
import org.wildfly.galleon.plugin.config.DeletePath;

public class DeletePathsModelParser20 {
    public static final String ELEMENT_LOCAL_NAME = "delete-paths";

    public List<DeletePath> parseDeletePaths(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<DeletePath> list = new ArrayList<DeletePath>();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return list;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DELETE: {
                            this.parseDeletePath(reader, list);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDeletePath(XMLStreamReader reader, List<DeletePath> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        boolean recursive = false;
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block4;
                }
                case RECURSIVE: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block4;
                    recursive = true;
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (path == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PATH));
        }
        list.add(new DeletePath(path, recursive));
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
    }

    static enum Attribute implements XmlNameProvider
    {
        PATH("path"),
        RECURSIVE("recursive"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>(2);
            attributesMap.put(PATH.getLocalName(), PATH);
            attributesMap.put(RECURSIVE.getLocalName(), RECURSIVE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        DELETE("delete"),
        UNKNOWN(null);

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            elements = Collections.singletonMap(DELETE.getLocalName(), DELETE);
        }
    }
}

