/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.CopyPath;
import org.wildfly.galleon.plugin.config.DeletePath;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.FilePermission;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasksParser;

public class WildFlyPackageTasks {
    private final List<CopyArtifact> copyArtifacts;
    private final List<CopyPath> copyPaths;
    private final List<DeletePath> deletePaths;
    private final List<FilePermission> filePermissions;
    private final List<String> mkDirs;
    private final List<FileFilter> windowsLineEndFilters;
    private final List<FileFilter> unixLineEndFilters;

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WildFlyPackageTasks load(Path configFile) throws ProvisioningException {
        try (InputStream configStream = Files.newInputStream(configFile, new OpenOption[0]);){
            WildFlyPackageTasks wildFlyPackageTasks = new WildFlyPackageTasksParser().parse(configStream);
            return wildFlyPackageTasks;
        }
        catch (XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml((Path)configFile), (Throwable)e);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.openFile((Path)configFile), (Throwable)e);
        }
    }

    private WildFlyPackageTasks(Builder builder) {
        this.copyArtifacts = CollectionUtils.unmodifiable((List)builder.copyArtifacts);
        this.copyPaths = CollectionUtils.unmodifiable((List)builder.copyPaths);
        this.deletePaths = CollectionUtils.unmodifiable((List)builder.deletePaths);
        this.filePermissions = CollectionUtils.unmodifiable((List)builder.filePermissions);
        this.mkDirs = CollectionUtils.unmodifiable((List)builder.mkDirs);
        this.windowsLineEndFilters = CollectionUtils.unmodifiable((List)builder.windowsLineEndFilters);
        this.unixLineEndFilters = CollectionUtils.unmodifiable((List)builder.unixLineEndFilters);
    }

    public boolean hasCopyArtifacts() {
        return !this.copyArtifacts.isEmpty();
    }

    public List<CopyArtifact> getCopyArtifacts() {
        return this.copyArtifacts;
    }

    public boolean hasCopyPaths() {
        return !this.copyPaths.isEmpty();
    }

    public List<CopyPath> getCopyPaths() {
        return this.copyPaths;
    }

    public boolean hasDeletePaths() {
        return !this.deletePaths.isEmpty();
    }

    public List<DeletePath> getDeletePaths() {
        return this.deletePaths;
    }

    public boolean hasFilePermissions() {
        return !this.filePermissions.isEmpty();
    }

    public List<FilePermission> getFilePermissions() {
        return this.filePermissions;
    }

    public boolean hasMkDirs() {
        return !this.mkDirs.isEmpty();
    }

    public List<String> getMkDirs() {
        return this.mkDirs;
    }

    public List<FileFilter> getWindowsLineEndFilters() {
        return this.windowsLineEndFilters;
    }

    public List<FileFilter> getUnixLineEndFilters() {
        return this.unixLineEndFilters;
    }

    public static class Builder {
        private List<CopyArtifact> copyArtifacts = Collections.emptyList();
        private List<CopyPath> copyPaths = Collections.emptyList();
        private List<DeletePath> deletePaths = Collections.emptyList();
        private List<FilePermission> filePermissions = Collections.emptyList();
        private List<String> mkDirs = Collections.emptyList();
        private List<FileFilter> windowsLineEndFilters = Collections.emptyList();
        private List<FileFilter> unixLineEndFilters = Collections.emptyList();

        private Builder() {
        }

        public Builder addCopyArtifact(CopyArtifact copy) {
            this.copyArtifacts = CollectionUtils.add(this.copyArtifacts, (Object)copy);
            return this;
        }

        public Builder addCopyPath(CopyPath copy) {
            this.copyPaths = CollectionUtils.add(this.copyPaths, (Object)copy);
            return this;
        }

        public Builder addCopyArtifacts(List<CopyArtifact> copyArtifacts) {
            for (CopyArtifact ca : copyArtifacts) {
                this.addCopyArtifact(ca);
            }
            return this;
        }

        public Builder addCopyPaths(List<CopyPath> copyPaths) {
            for (CopyPath ca : copyPaths) {
                this.addCopyPath(ca);
            }
            return this;
        }

        public Builder addDeletePath(DeletePath deletePath) {
            this.deletePaths = CollectionUtils.add(this.deletePaths, (Object)deletePath);
            return this;
        }

        public Builder addDeletePaths(List<DeletePath> deletePaths) {
            for (DeletePath dp : deletePaths) {
                this.addDeletePath(dp);
            }
            return this;
        }

        public Builder addFilePermissions(FilePermission filePermission) {
            this.filePermissions = CollectionUtils.add(this.filePermissions, (Object)filePermission);
            return this;
        }

        public Builder addFilePermissions(List<FilePermission> filePermissions) {
            for (FilePermission fp : filePermissions) {
                this.addFilePermissions(fp);
            }
            return this;
        }

        public Builder addMkDirs(String mkdirs) {
            this.mkDirs = CollectionUtils.add(this.mkDirs, (Object)mkdirs);
            return this;
        }

        public Builder addMkDirs(List<String> mkdirs) {
            for (String mkdir : mkdirs) {
                this.addMkDirs(mkdir);
            }
            return this;
        }

        public Builder addWindowsLineEndFilter(FileFilter filter) {
            this.windowsLineEndFilters = CollectionUtils.add(this.windowsLineEndFilters, (Object)filter);
            return this;
        }

        public Builder addWindowsLineEndFilters(List<FileFilter> filters) {
            for (FileFilter filter : filters) {
                this.addWindowsLineEndFilter(filter);
            }
            return this;
        }

        public Builder addUnixLineEndFilter(FileFilter filter) {
            this.unixLineEndFilters = CollectionUtils.add(this.unixLineEndFilters, (Object)filter);
            return this;
        }

        public Builder addUnixLineEndFilters(List<FileFilter> filters) {
            for (FileFilter filter : filters) {
                this.addUnixLineEndFilter(filter);
            }
            return this;
        }

        public WildFlyPackageTasks build() {
            return new WildFlyPackageTasks(this);
        }
    }
}

