/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.plugin.config.CopyArtifactsModelParser20;
import org.wildfly.galleon.plugin.config.CopyPathsModelParser20;
import org.wildfly.galleon.plugin.config.DeletePathsModelParser20;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.FileFilterModelParser20;
import org.wildfly.galleon.plugin.config.FilePermissionsModelParser20;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasks;

class WildFlyPackageTasksParser20
implements XMLElementReader<WildFlyPackageTasks.Builder> {
    private final CopyArtifactsModelParser20 copyArtifactsModelParser;
    private final CopyPathsModelParser20 copyPathsModelParser;
    private final FileFilterModelParser20 fileFilterModelParser = new FileFilterModelParser20();
    private final FilePermissionsModelParser20 filePermissionsModelParser;
    private final DeletePathsModelParser20 deletePathsModelParser;

    WildFlyPackageTasksParser20() {
        this.copyArtifactsModelParser = new CopyArtifactsModelParser20(this.fileFilterModelParser);
        this.copyPathsModelParser = new CopyPathsModelParser20();
        this.filePermissionsModelParser = new FilePermissionsModelParser20(this.fileFilterModelParser);
        this.deletePathsModelParser = new DeletePathsModelParser20();
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACTS: {
                            builder.addCopyArtifacts(this.copyArtifactsModelParser.parseCopyArtifacts(reader));
                            continue block12;
                        }
                        case COPY_PATHS: {
                            builder.addCopyPaths(this.copyPathsModelParser.parseCopyPaths(reader));
                            continue block12;
                        }
                        case DELETE_PATHS: {
                            builder.addDeletePaths(this.deletePathsModelParser.parseDeletePaths(reader));
                            continue block12;
                        }
                        case FILE_PERMISSIONS: {
                            builder.addFilePermissions(this.filePermissionsModelParser.parseFilePermissions(reader));
                            continue block12;
                        }
                        case MKDIRS: {
                            this.parseMkdirs(reader, builder);
                            continue block12;
                        }
                        case LINE_ENDINGS: {
                            this.parseLineEndings(reader, builder);
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private void parseMkdirs(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DIR: {
                            builder.addMkDirs(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEndings(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case WINDOWS: {
                            this.parseLineEnding(reader, builder, true);
                            continue block8;
                        }
                        case UNIX: {
                            this.parseLineEnding(reader, builder, true);
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEnding(XMLStreamReader reader, WildFlyPackageTasks.Builder builder, boolean windows) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            FileFilter.Builder filterBuilder = FileFilter.builder();
                            this.fileFilterModelParser.parseFilter(reader, filterBuilder);
                            if (windows) {
                                builder.addWindowsLineEndFilter(filterBuilder.build());
                                continue block7;
                            }
                            builder.addUnixLineEndFilter(filterBuilder.build());
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        NAME("name"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributes = attributesMap;
        }
    }

    static enum Element {
        COPY_ARTIFACTS("copy-artifacts"),
        COPY_PATHS("copy-paths"),
        DELETE_PATHS("delete-paths"),
        DIR("dir"),
        FILE_PERMISSIONS("file-permissions"),
        FILTER("filter"),
        LINE_ENDINGS("line-endings"),
        MKDIRS("mkdirs"),
        TASKS("tasks"),
        UNIX("unix"),
        WINDOWS("windows"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", COPY_ARTIFACTS.getLocalName()), COPY_ARTIFACTS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", COPY_PATHS.getLocalName()), COPY_PATHS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", DELETE_PATHS.getLocalName()), DELETE_PATHS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", DIR.getLocalName()), DIR);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", LINE_ENDINGS.getLocalName()), LINE_ENDINGS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", MKDIRS.getLocalName()), MKDIRS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", TASKS.getLocalName()), TASKS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", UNIX.getLocalName()), UNIX);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", WINDOWS.getLocalName()), WINDOWS);
            elements = elementsMap;
        }
    }
}

