/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wildfly.galleon.plugin.config.FileFilter;

public class CopyArtifact {
    private final String artifact;
    private final String toLocation;
    private final boolean extract;
    private final List<FileFilter> filters;

    public static Builder builder() {
        return new Builder();
    }

    private CopyArtifact(String artifact, String toLocation, boolean extract, List<FileFilter> filters) {
        this.artifact = artifact;
        this.toLocation = toLocation;
        this.extract = extract;
        this.filters = filters;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getToLocation() {
        return this.toLocation;
    }

    public boolean isExtract() {
        return this.extract;
    }

    public List<FileFilter> getFilters() {
        return this.filters;
    }

    public boolean includeFile(String path) {
        for (FileFilter filter : this.filters) {
            if (!filter.matches(path)) continue;
            return filter.isInclude();
        }
        return true;
    }

    public static class Builder {
        private String artifact;
        private String toLocation;
        private boolean extract;
        private List<FileFilter> filters = Collections.emptyList();

        private Builder() {
        }

        public Builder setArtifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder setToLocation(String toLocation) {
            this.toLocation = toLocation;
            return this;
        }

        public Builder setExtract() {
            this.extract = true;
            return this;
        }

        public Builder addFilter(FileFilter filter) {
            switch (this.filters.size()) {
                case 0: {
                    this.filters = Collections.singletonList(filter);
                    break;
                }
                case 1: {
                    this.filters = new ArrayList<FileFilter>(this.filters);
                }
                default: {
                    this.filters.add(filter);
                }
            }
            return this;
        }

        public CopyArtifact build() {
            return new CopyArtifact(this.artifact, this.toLocation, this.extract, this.filters);
        }
    }
}

