/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.regex.Pattern;
import org.jboss.galleon.util.ParsingUtils;

public class FileFilter {
    private final String patternString;
    private final Pattern pattern;
    private final boolean include;

    public static Builder builder() {
        return new Builder();
    }

    private FileFilter(String patternString, boolean include) {
        if (patternString == null) {
            throw new IllegalArgumentException("null pattern");
        }
        this.patternString = patternString;
        this.pattern = Pattern.compile(ParsingUtils.wildcardToJavaRegexp((String)patternString));
        this.include = include;
    }

    public String getPattern() {
        return this.patternString;
    }

    public boolean matches(String filePath) {
        return this.pattern.matcher(filePath).matches();
    }

    public boolean isInclude() {
        return this.include;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileFilter that = (FileFilter)o;
        return this.patternString.equals(that.patternString);
    }

    public int hashCode() {
        return this.patternString.hashCode();
    }

    public String toString() {
        return this.patternString;
    }

    public static class Builder {
        private String patternString;
        private boolean include;

        private Builder() {
        }

        public Builder setPatternString(String patternString) {
            this.patternString = patternString;
            return this;
        }

        public Builder setInclude() {
            this.include = true;
            return this;
        }

        public FileFilter build() {
            return new FileFilter(this.patternString, this.include);
        }
    }
}

