/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.FileFilterModelParser20;
import org.wildfly.galleon.plugin.config.FilePermission;

public class FilePermissionsModelParser20 {
    public static final String ELEMENT_LOCAL_NAME = "file-permissions";
    private final FileFilterModelParser20 fileFilterModelParser;

    public FilePermissionsModelParser20() {
        this(new FileFilterModelParser20());
    }

    public FilePermissionsModelParser20(FileFilterModelParser20 fileFilterModelParser) {
        this.fileFilterModelParser = fileFilterModelParser;
    }

    public List<FilePermission> parseFilePermissions(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<FilePermission> list = new ArrayList<FilePermission>();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return list;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PERMISSION: {
                            list.add(this.parsePermission(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    protected FilePermission parsePermission(XMLStreamReader reader) throws XMLStreamException {
        FilePermission.Builder permissionBuilder = FilePermission.builder();
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    permissionBuilder.setValue(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return permissionBuilder.build();
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            FileFilter.Builder filterBuilder = FileFilter.builder();
                            this.fileFilterModelParser.parseFilter(reader, filterBuilder);
                            permissionBuilder.addFilter(filterBuilder.build());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        UNKNOWN(null),
        VALUE("value");

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>();
            attributesMap.put(VALUE.getLocalName(), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        PERMISSION("permission"),
        FILTER("filter");

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Element> elementsMap = new HashMap<String, Element>();
            elementsMap.put(PERMISSION.getLocalName(), PERMISSION);
            elementsMap.put(FILTER.getLocalName(), FILTER);
            elements = elementsMap;
        }
    }
}

