/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.IoUtils;

public class ForkedEmbeddedUtil {
    public static void fork(ForkCallback callback, String ... args) throws ProvisioningException {
        Path props = ForkedEmbeddedUtil.storeSystemProps();
        try {
            ForkedEmbeddedUtil.fork(callback, props, args);
        }
        finally {
            IoUtils.recursiveDelete((Path)props);
        }
    }

    public static void fork(ForkCallback callback, Path props, String ... args) throws ProvisioningException {
        Process p;
        StringBuilder cp = new StringBuilder();
        ForkedEmbeddedUtil.collectCpUrls(System.getProperty("java.home"), Thread.currentThread().getContextClassLoader(), cp);
        ArrayList<String> argsList = new ArrayList<String>(6 + args.length);
        argsList.add("java");
        argsList.add("-cp");
        argsList.add(cp.toString());
        argsList.add(ForkedEmbeddedUtil.class.getName());
        argsList.add(props.toString());
        argsList.add(callback.getClass().getName());
        for (String arg : args) {
            argsList.add(arg);
        }
        try {
            p = new ProcessBuilder(argsList).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to start a feature spec reading process", (Throwable)e);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            int exitCode;
            String line = reader.readLine();
            while (line != null) {
                callback.forkedEmbeddedMessage(line);
                line = reader.readLine();
            }
            if (p.isAlive()) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((exitCode = p.exitValue()) != 0) {
                throw new ProvisioningException("Forked embedded process has failed");
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Forked embedded process has failed", (Throwable)e);
        }
    }

    public static Path storeSystemProps() throws ProvisioningException {
        Path props;
        try {
            props = Files.createTempFile("wfgp", "sysprops", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to create a tmp file", (Throwable)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(props, new OpenOption[0]);){
            System.getProperties().store(writer, "");
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile((Path)props), (Throwable)e);
        }
        return props;
    }

    public static void main(String ... args) {
        try {
            Object o;
            Class<?> cls;
            if (args.length < 2) {
                throw new IllegalStateException("Expected at least two arguments but got " + Arrays.asList(args));
            }
            ForkedEmbeddedUtil.setSystemProps(args[0]);
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(args[1]);
            }
            catch (ClassNotFoundException e) {
                throw new ProvisioningException("Failed to locate the target class " + args[1], (Throwable)e);
            }
            try {
                o = cls.newInstance();
            }
            catch (Exception e) {
                throw new ProvisioningException("Failed to instantiate " + args[1], (Throwable)e);
            }
            ((ForkCallback)o).forkedForEmbedded(args.length == 2 ? new String[]{} : Arrays.copyOfRange(args, 2, args.length));
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void setSystemProps(String path) throws ProvisioningException {
        Path props = Paths.get(path, new String[0]);
        if (!Files.exists(props, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)props));
        }
        Properties tmp = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(props);){
            tmp.load(reader);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile((Path)props));
        }
        for (Map.Entry<Object, Object> prop : tmp.entrySet()) {
            String current = System.getProperty(prop.getKey().toString());
            if (current != null) continue;
            System.setProperty(prop.getKey().toString(), prop.getValue().toString());
        }
    }

    private static void collectCpUrls(String javaHome, ClassLoader cl, StringBuilder buf) {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            ForkedEmbeddedUtil.collectCpUrls(javaHome, cl.getParent(), buf);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String file = url.getFile();
                if (file.startsWith(javaHome)) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file);
            }
        }
    }

    public static interface ForkCallback {
        public void forkedForEmbedded(String ... var1) throws ProvisioningException;

        default public void forkedEmbeddedMessage(String msg) {
        }
    }
}

